
<!DOCTYPE html>
<html>
<head>
    <title>Blogs</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">    
    <?php echo $__env->make('frontend.includes.header-link', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</head>
<body>

    <!-- <div id="loader"></div> -->

    <div class="main-body" >

        <!-- header -->
        <?php echo $__env->make('frontend.includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- /header -->

        <!-- main content -->
        <div class="main-content">

            <!-- banner starts -->
            <div class="banner-sec" style="background-image: url(assets/images/about-banner-bg.png);">
                <div class="container">
                    <div class="banner-wrapper">
                        <h1>
                            Blogs
                        </h1>
                        <p>
                            
                        </p>
                        <div class="scroll-div d-flex align-items-center justify-content-center">
                            <p>
                                scroll down
                                <br><br>
                                <img src="assets/images/fi_6364586.png" alt="...">
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /banner ends -->

            <!-- blags starts -->
            <div class="blog-sec">
                <div class="container">
                    <div class="blog-wrspper">
                        <div class="row">
                            <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-lg-4 col-md-6 col-12">
                                    <div class="blog-item">
                                        <div class="blog-item-img-heading">
                                            <img src="<?php echo e(asset($blog->image)); ?>" alt="<?php echo e($blog->title); ?>">
                                            <div class="blog-item-heading">
                                                <div class="d-flex align-items-center mb-3">
                                                    <p class="mr-2">
                                                        <img src="<?php echo e(asset('assets/images/blog-user-icon.png')); ?>" alt="">
                                                        by Admin
                                                    </p>
                                                    <p>
                                                        <img src="<?php echo e(asset('assets/images/blog-folder-icon.png')); ?>" alt="">
                                                        Blog
                                                    </p>
                                                </div>
                                                <h6><?php echo e(\Illuminate\Support\Str::limit($blog->title, 50)); ?></h6>
                                                <p class="date-p">
                                                    <?php echo e(\Carbon\Carbon::parse($blog->created_at)->format('d')); ?> <br>
                                                    <span><?php echo e(\Carbon\Carbon::parse($blog->created_at)->format('M')); ?></span>
                                                </p>
                                            </div>
                                        </div>
                                        <p class="mb-4">
                                            <?php echo e(\Illuminate\Support\Str::limit(strip_tags($blog->body), 150)); ?>

                                        </p>
                                        <a href="<?php echo e(route('blogs.show', $blog->slug)); ?>">
                                            <img src="<?php echo e(asset('assets/images/arrow.png')); ?>" alt="...">
                                            <span>Read More</span>
                                        </a>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <?php if($blogs->hasPages()): ?>
                        <div class="blog-pagination">
                            <div class="blog-pagination-list text-center d-flex justify-content-center align-items-center gap-2 flex-wrap">

                                
                                <?php if($blogs->onFirstPage()): ?>
                                    <span><img src="<?php echo e(asset('assets/images/pagination-left.png')); ?>" alt="..."></span>
                                <?php else: ?>
                                    <a href="<?php echo e($blogs->previousPageUrl()); ?>">
                                        <img src="<?php echo e(asset('assets/images/pagination-left.png')); ?>" alt="...">
                                    </a>
                                <?php endif; ?>

                                
                                <?php $__currentLoopData = $blogs->getUrlRange(1, $blogs->lastPage()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($page == $blogs->currentPage()): ?>
                                        <a ><?php echo e($page); ?></a>
                                    <?php else: ?>
                                        <a href="<?php echo e($url); ?>" ><?php echo e($page); ?></a>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                
                                <?php if($blogs->hasMorePages()): ?>
                                    <a href="<?php echo e($blogs->nextPageUrl()); ?>">
                                        <img src="<?php echo e(asset('assets/images/pagination-right.png')); ?>" alt="...">
                                    </a>
                                <?php else: ?>
                                    <span><img src="<?php echo e(asset('assets/images/pagination-right.png')); ?>" alt="..."></span>
                                <?php endif; ?>

                            </div>
                        </div>
                    <?php endif; ?>

                </div>
            </div>
            <!-- /blags ends -->
            
        </div>
        <!-- /main content -->

        <!-- footer -->
        <?php echo $__env->make('frontend.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- /footer -->
        
    </div>
    <?php echo $__env->make('frontend.includes.footer-link', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</body>
</html>

<?php /**PATH C:\xampp\htdocs\litigation\resources\views/frontend/blog.blade.php ENDPATH**/ ?>