

<?php $__env->startSection('content'); ?>
<div class="container-fluid mt-4 px-4">
    <div class="row">
        <div class="col-12">
            <div class="card shadow-sm">

                <div class="card-header d-flex justify-content-between align-items-center bg-primary text-white">
                    <h4 class="mb-0">Testimonial List</h4>
                    <a href="<?php echo e(route('admin.testimonials.create')); ?>" class="btn btn-dark btn-sm ms-auto">+ Add Testimonial</a>
                </div>

                <div class="card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                    <?php endif; ?>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th style="width: 15%;">Name</th>
                                    <th style="width: 15%;">Designation</th>
                                    <th>Message</th>
                                    <th style="width: 10%;">Image</th>
                                    <th style="width: 15%;">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($testimonial->name); ?></td>
                                        <td><?php echo e($testimonial->designation); ?></td>
                                        <td><?php echo e(Str::limit($testimonial->message, 100)); ?></td>
                                        <td>
                                            <?php if($testimonial->image): ?>
                                                <img src="<?php echo e(asset($testimonial->image)); ?>" width="60" class="img-thumbnail">
                                            <?php else: ?>
                                                <span class="text-muted">N/A</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <a href="<?php echo e(route('admin.testimonials.edit', $testimonial->id)); ?>" class="btn btn-sm btn-warning">Edit</a>
                                            <form action="<?php echo e(route('admin.testimonials.destroy', $testimonial->id)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Delete this testimonial?');">
                                                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                                <button class="btn btn-sm btn-danger">Delete</button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="5" class="text-center text-muted">No testimonials found.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="d-flex justify-content-end">
                        <?php echo e($testimonials->links()); ?>

                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\litigation\resources\views/admin/testimonials/index.blade.php ENDPATH**/ ?>