
<!DOCTYPE html>
<html>
<head>
    <title>Service Details</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <?php echo $__env->make('frontend.includes.header-link', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <style>
        .about-who-we-help-sec div.about-who-we-help-content p {
            margin-bottom: 20px;
        }
        .about-who-we-help-sec.service-deatils-sec {
            padding-bottom: 30px;
        }
        .service-deatils-sec h5 {
            font-size: 33px;
            font-family: "Pratt Nova Light", serif;
            margin-bottom: 20px;
            line-height: 100%;
            font-weight: 300;
        }
        .service-deatils-sec h6 {
            font-size: 22px;
            font-weight: 300;
            margin-bottom: 10px;
        }
        .service-deatils-sec p {
            font-size: 16px !important;
            font-weight: 200 !important;
            margin-bottom: 20px !important;
            line-height: 28px !important;
        }
        .service-deatils-sec .about-who-we-help-content ul {
            margin-left: 15px;
            margin-bottom: 20px;
        }
        .service-deatils-sec .about-who-we-help-content li {
            padding: 5px 5px 5px 20px;
            font-size: 14px;
            line-height: 20px;
            border: 0px;
            font-weight: 200;
        }
        .service-deatils-sec .about-who-we-help-content li::after {
            content: "";
            width: 7px;
            height: 7px;
            background-image: none;
            position: absolute;
            left: 0;
            top: 50%;
            transform: translateY(-50%);
            background-color: white;
            border-radius: 50%;
        }
    </style>

</head>
<body>

    <!-- <div id="loader"></div> -->

    <div class="main-body" >

        <!-- header -->
        <?php echo $__env->make('frontend.includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- /header -->

        <!-- main content -->
        <div class="main-content">

            <!-- banner starts -->
            <div class="banner-sec" style="background-image: url('<?php echo e(asset('assets/images/about-banner-bg.png')); ?>');">
                <div class="container">
                    <div class="banner-wrapper">
                        <h1>
                            Service Details
                        </h1>
                        <p>
                            CORPORATES & MSMEs Capitalizing Strength. Defending Value. 
                        </p>
                        <div class="scroll-div d-flex align-items-center justify-content-between">
                            <p>
                                scroll down
                                <br><br>
                                <img src="<?php echo e(asset('assets/images/fi_6364586.png')); ?>" alt="...">
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /banner ends -->

            <!-- Who We Help starts -->
            <div class="about-who-we-help-sec service-deatils-sec">
                <div class="container">
                    <div class="about-who-we-help-wrapper">
                        <div class="row align-items-center">
                            <div class="col-lg-5 col-md-5 col-12">
                                <div class="about-who-we-help-image">
                                     <img src="<?php echo e(asset($item->image)); ?>" alt="<?php echo e($item->title); ?>">
                                </div>
                            </div>
                            <div class="col-lg-7 col-md-7 col-12">
                                <div class="about-who-we-help-content">
                                    <h5>
                                        <?php echo e($item->title); ?>

                                    </h5>
                                    <h6>
                                        <b><?php echo e($item->subtitle); ?></b>
                                    </h6>
                                    <p>
                                        <?php echo e($item->short_description); ?>

                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="about-who-we-help-content mt-5">
                            <?php echo html_entity_decode($item->body); ?>

                        </div>
                    </div>
                </div>
            </div>
            <!-- /Who We Help ends -->

            <!-- other services starts -->
            <div class="who-we-help-sec">
                <div class="container">
                    <div class="heading-sec">
                        <div class="heading-text">  
                            <h3>
                                Other services
                            </h3>
                            <p>
                            At LitigationFundings.com, we don’t just provide capital. We unlock possibilities. Our solutions are purpose-built for stakeholders across the legal and financial spectrum, enabling them to pursue high-value, high-stakes disputes without financial compromise. Explore who we serve:
                            </p>
                        </div>
                    </div>
                    <div class="who-we-help-wrapper">
                        <div class="swiper who-we-help-slider swiper-initialized swiper-horizontal swiper-backface-hidden">
                            <div class="swiper-wrapper" id="swiper-wrapper-795c110c45cb14dee" aria-live="polite">
                                <?php $__currentLoopData = $alldata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="swiper-slide swiper-slide-active" role="group" aria-label="1 / 4" data-swiper-slide-index="0" style="width: 383px; margin-right: 10px;">
                                    <div class="who-we-help-item">
                                    <img src="<?php echo e(asset($value->image)); ?>" alt="<?php echo e($value->title); ?>">
                                    <h5><?php echo e(\Illuminate\Support\Str::limit($value->title, 28)); ?></h5>
                                        <h6> <?php echo e($value->subtitle); ?></h6>
                                        <p><?php echo e(\Illuminate\Support\Str::words(html_entity_decode(strip_tags($value->short_description)), 20, '...')); ?></p>
                                        <a href="<?php echo e(route('who-we-help.show', $value->slug)); ?>">
                                            <img src="<?php echo e(asset('assets/images/arrow.png')); ?>" alt="...">
                                            <span>
                                                View Details
                                            </span>
                                        </a>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <div class="swiper-pagination swiper-pagination-clickable swiper-pagination-bullets swiper-pagination-horizontal"><span class="swiper-pagination-bullet swiper-pagination-bullet-active" tabindex="0" role="button" aria-label="Go to slide 1" aria-current="true"></span><span class="swiper-pagination-bullet" tabindex="0" role="button" aria-label="Go to slide 2"></span><span class="swiper-pagination-bullet" tabindex="0" role="button" aria-label="Go to slide 3"></span><span class="swiper-pagination-bullet" tabindex="0" role="button" aria-label="Go to slide 4"></span></div>
                        <span class="swiper-notification" aria-live="assertive" aria-atomic="true"></span></div>
                    </div>
                </div>
            </div>
            <!-- /other services ends -->
            
        </div>
        <!-- /main content -->

        <!-- footer -->
        <?php echo $__env->make('frontend.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- /footer -->
        
    </div>

    <?php echo $__env->make('frontend.includes.footer-link', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</body>
</html>

<?php /**PATH C:\xampp\htdocs\litigation\resources\views/frontend/who-we-help-details.blade.php ENDPATH**/ ?>