

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-sm-12">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0"><?php echo e(isset($contact) ? 'Edit' : 'Add'); ?> Contact Entry</h4>
                </div>

                <div class="card-body">
                    <form action="<?php echo e(isset($contact) ? route('admin.contact-us.update', $contact->id) : route('admin.contact-us.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php if(isset($contact)): ?> <?php echo method_field('PUT'); ?> <?php endif; ?>

                        <div class="mb-3">
                            <label>Name</label>
                            <input type="text" name="name" class="form-control" value="<?php echo e(old('name', $contact->name ?? '')); ?>" required>
                        </div>
                        <div class="mb-3">
                            <label>Email</label>
                            <input type="email" name="email" class="form-control" value="<?php echo e(old('email', $contact->email ?? '')); ?>" required>
                        </div>
                        <div class="mb-3">
                            <label>Phone</label>
                            <input type="text" name="phone" class="form-control" value="<?php echo e(old('phone', $contact->phone ?? '')); ?>">
                        </div>
                        <div class="mb-3">
                            <label>City</label>
                            <input type="text" name="city" class="form-control" value="<?php echo e(old('city', $contact->city ?? '')); ?>">
                        </div>
                        <div class="mb-3">
                            <label>Nature of Work</label><br>
                            <?php
                                $selectedWorkIds = [];
                                if (isset($contact) && !empty($contact->nature_of_work)) {
                                    $selectedWorkIds = explode(',', $contact->nature_of_work);
                                }
                            ?>

                            <?php $__currentLoopData = $natureOfInvestments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $investment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="form-check form-check-inline">
                                    <input type="checkbox" name="nature_of_work[]" class="form-check-input"
                                        value="<?php echo e($investment->id); ?>"
                                        <?php echo e(in_array($investment->id, $selectedWorkIds) ? 'checked' : ''); ?>>
                                    <label class="form-check-label"><?php echo e($investment->name); ?></label>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>

                        <button type="submit" class="btn btn-primary"><?php echo e(isset($contact) ? 'Update' : 'Submit'); ?></button>
                        <a href="<?php echo e(route('admin.contact-us.index')); ?>" class="btn btn-secondary">Back</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\litigation\resources\views/admin/contact-us/addedit.blade.php ENDPATH**/ ?>