

<?php $__env->startSection('content'); ?>
<div class="container-fluid mt-4 px-4">
    <div class="row">
        <div class="col-12">
            <div class="card shadow-sm">
            <div class="card-header d-flex justify-content-between align-items-center bg-primary text-white">
                <h4 class="mb-0">Blog List</h4>
                <a href="<?php echo e(route('admin.blogs.create')); ?>" class="btn btn-dark btn-sm ms-auto">+ Add Blog</a>
            </div>

                <div class="card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                    <?php endif; ?>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th style="width: 20%;">Title</th>
                                    <th style="width: 15%;">Slug</th>
                                    <th>Description</th>
                                    <th style="width: 15%;">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($blog->title); ?></td>
                                        <td><?php echo e($blog->slug); ?></td>
                                        <td><?php echo \Illuminate\Support\Str::limit(strip_tags($blog->body), 150, '...'); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('admin.blogs.edit', $blog)); ?>" class="btn btn-sm btn-warning">Edit</a>
                                            <form action="<?php echo e(route('admin.blogs.destroy', $blog)); ?>" method="POST" style="display:inline-block;" onsubmit="return confirm('Are you sure?');">
                                                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                                <button class="btn btn-sm btn-danger">Delete</button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="4" class="text-center text-muted">No blogs found.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="d-flex justify-content-end">
                        <?php echo e($blogs->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\litigation\resources\views/admin/blog/index.blade.php ENDPATH**/ ?>