
<!DOCTYPE html>
<html>
<head>
    <title>What We Do</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php echo $__env->make('frontend.includes.header-link', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <style>
        .service-list-item {
            width: 100%;
            height: 250px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 4px;
            /* background-image: url(); */
            background-size: cover;
            position: relative;
            z-index: 1;
            box-shadow: 7px 7px 27px #00000014;
        }
        .service-list-item::before {
            content: " ";
            width: 100%;
            height: 100%;
            border-radius: 4px;
            background-color: #00000094;
            z-index: 0;
            position: absolute;
            left: 0;
            top: 0;
        }
        .service-list-item h4 {
            font-size: 20px;
            color: white;
            font-weight: 600;
            position: relative;
            z-index: 1;
        }
        .service-list-item a {
            display: inline-block;
            width: 70%;
            line-height: 40px;
            background-color: #f1d265;
            font-size: 20px;
            font-weight: 500;
            color: #001729;
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            bottom: 15px;
            text-align: center;
            border-radius: 4px;
        }
    </style>
</head>
<body>

    <!-- <div id="loader"></div> -->

    <div class="main-body" >

        <!-- header -->
        <?php echo $__env->make('frontend.includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- /header -->

        <!-- main content -->
        <div class="main-content">

            <!-- banner starts -->
            <div class="banner-sec" style="background-image: url(assets/images/about-banner-bg.png);">
                <div class="container">
                    <div class="banner-wrapper">
                        <h1>
                            What We Do
                        </h1>
                        
                        <div class="banner-btn">
                            <button class="main-btn-black">Call us</button>
                        </div>
                        <div class="scroll-div d-flex align-items-center justify-content-center">
                            <p>
                                scroll down
                                <br><br>
                                <img src="assets/images/fi_6364586.png" alt="...">
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /banner ends -->

            <!-- Who We Help starts -->
            <div class="about-who-we-help-sec">
                <div class="container">
                    <div class="about-who-we-help-wrapper">
                        <div class="row align-items-center">
                            <div class="col-lg-6 col-md-6 col-12">
                                <div class="about-who-we-help-image">
                                    <img src="assets/images/who-we-help.png" alt="...">
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-12">
                                <div class="about-who-we-help-content">
                                    <h3>
                                        What We Do
                                    </h3>
                                    <p>
                                       At LitigationFundings.com (a Nyaya Mitra Ltd. initiative), we help litigants unlock justice through 
                                        strategic funding solutions—without the burden of upfront legal costs. Our services are tailored 
                                        for corporates, investors, legal professionals, and institutions involved in complex, high-value 
                                        disputes.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Who We Help ends -->


            <!-- Who We do it for starts -->
            <div class="who-we-help-sec service-list-sec">
                <div class="container">
                    <div class="heading-sec d-flex align-items-center justify-content-between">
                        <div class="heading-text">  
                            <h3>
                                What We Do
                            </h3>
                            
                        </div>
                        <div class="heading-button">
                            <a href="<?php echo e(route('frontend.what-we-do.list')); ?>" class="d-flex align-items-center">
                                <img src="<?php echo e(asset('assets/images/arrow.png')); ?>" alt="...">
                                <span>
                                    View All Services
                                </span>
                            </a>
                        </div>
                    </div>
                    <div class="who-we-help-wrapper">
                        <div class="swiper who-we-help-slider">
                           <div class="swiper-wrapper">
                                <?php $__currentLoopData = $WhatWeDoList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="swiper-slide">
                                        <div class="who-we-help-item">
                                            <img src="<?php echo e(asset($item->image)); ?>" alt="<?php echo e($item->title); ?>">
                                            <h5><?php echo e($item->title); ?></h5>
                                            <a href="<?php echo e(route('frontend.what-we-do.show', $item->slug)); ?>">
                                                <img src="<?php echo e(asset('assets/images/arrow.png')); ?>" alt="arrow">
                                                <span>View Details</span>
                                            </a>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            <div class="swiper-pagination"></div>
                        </div>
                        <div class="slider-controls">
                            <div class="swiper-button-prev"></div>
                            <div class="swiper-button-next"></div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Who We do it for ends -->

           

            <!-- Who We Help starts -->
            <div class="about-who-we-help-sec client-consultancy-sec-1">
                <div class="container">
                    <div class="about-who-we-help-wrapper">
                        <div class="row align-items-center">
                            <div class="col-lg-6 col-md-6 col-12">
                                <div class="about-who-we-help-content">
                                    <h3>
                                        Our Impact
                                    </h3>
                                    <ul>
                                        <li>
                                            Legal heirs or nominees of unclaimed investments
                                        </li>
                                        <li>
                                            Investors seeking to recover forgotten or unclaimed assets
                                        </li>
                                        <li>
                                            Legal heirs or nominees of unclaimed investments
                                        </li>
                                        <li>
                                            Individuals struggling with share transmission or duplicate issues
                                        </li>
                                        <li>
                                            Clients involved in financial disputes or seeking litigation funding
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-lg-1 col-md-1 col-12"></div>
                            <div class="col-lg-5 col-md-5 col-12">
                                <div class="about-who-we-help-image">
                                    <img src="assets/images/who-should-reach-out.jpg" alt="...">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Who We Help ends -->

            <!-- We proudly serve a wide range of partners starts -->
            <div class="why-litigation-funding-sec partners-starts-sec">
                <div class="container">
                    <div class="heading-sec">
                        <div class="heading-text text-center">  
                            <h3>
                                We proudly serve a wide range of partners
                            </h3>
                        </div>
                    </div>
                    <div class="why-litigation-funding-wrapper partners-starts-wrapper">
                        <div class="swiper partners-slider">
                            <div class="swiper-wrapper">
                                <div class="swiper-slide">
                                    <img src="assets/images/partners-1.png" alt="...">
                                </div>
                                <div class="swiper-slide">
                                    <img src="assets/images/partners-2.png" alt="...">
                                </div>
                                <div class="swiper-slide">
                                    <img src="assets/images/partners-3.png" alt="...">
                                </div>
                                <div class="swiper-slide">
                                    <img src="assets/images/partners-4.png" alt="...">
                                </div>
                                <div class="swiper-slide">
                                    <img src="assets/images/partners-5.png" alt="...">
                                </div>
                                <div class="swiper-slide">
                                    <img src="assets/images/partners-3.png" alt="...">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /We proudly serve a wide range of partners ends -->

            <!-- Claim Now starts -->
            <div class="claim-now-sec">
                <div class="container">
                    <div class="claim-now-wrapper">
                        <div class="row">
                            <div class="col-lg-6 col-md-6 col-12">
                                <div class="claim-now-text">
                                    <div class="heading-text-sec">
                                        <div class="heading-sec">
                                            <div class="heading-text">  
                                                <h3>
                                                    Claim Now
                                                </h3>
                                                <p>
                                                    Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt Lorem ipsum dolor sit amet
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <p>
                                        Call Now  <a href="tel:2222223333">222 222 3333</a> 
                                    </p>
                                    <img src="assets/images/about-claim-now.png" alt="...">
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-12">
                                <div class="claim-now-form">
                                    <h5>
                                        find Out the Form Below
                                    </h5>
                                    <?php if(session('success')): ?>
                                        <div class="alert alert-success" style="color: green; margin-bottom: 20px;">
                                            <?php echo e(session('success')); ?>

                                        </div>
                                    <?php endif; ?>
                                    <?php if($errors->any()): ?>
                                        <div class="alert alert-danger">
                                            <ul style="margin: 0; padding-left: 20px;">
                                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li><?php echo e($error); ?></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </div>
                                    <?php endif; ?>

                                    <?php $__errorArgs = ['captcha'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <form action="<?php echo e(route('contact.submit')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <div class="form-item">
                                            <label>Name</label>
                                            <input type="text" name="name" placeholder="Enter your Name">
                                        </div>
                                        <div class="form-item">
                                            <label>Email</label>
                                            <input type="text" name="email" placeholder="Enter your Email">
                                        </div>
                                        <div class="form-item">
                                            <label>Phone</label>
                                            <input type="text" name="phone" placeholder="Enter Your Phone">
                                        </div>
                                        <div class="form-item">
                                            <label>City</label>
                                            <input type="text" name="city" placeholder="Enter Your City">
                                        </div>
                                        <div class="form-item w-100">
                                            <label>Please select the Nature of Work / Money to be recovered</label>
                                            <br><br>
                                            <div class="checkbox-input-div">
                                                <?php $__currentLoopData = $natureOfInvestments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $investment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <label class="checkbox-input-label">
                                                        <input type="checkbox" class="checkbox-input" name="nature_of_work[]" value="<?php echo e($investment->id); ?>">
                                                        <?php echo e($investment->name); ?>

                                                    </label>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            </div>
                                        </div>
                                        <div class="g-recaptcha" data-sitekey="<?php echo e(config('services.recaptcha.site_key')); ?>"></div>
                                        <div class="form-item">
                                            <button type="submit">Submit</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Claim Now ends -->
            
        </div>
        <!-- /main content -->

        <!-- footer -->
        <?php echo $__env->make('frontend.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- /footer -->
        
    </div>
    <?php echo $__env->make('frontend.includes.footer-link', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Include reCAPTCHA script -->
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>

    <script>
            var swiper = new Swiper(".partners-slider", {
              slidesPerView: 5,
              spaceBetween: 50,
              loop: true,
              autoplay: false,
              breakpoints: {
                100: {
                  slidesPerView: 2,
                  spaceBetween: 10
                },
                768: {
                  slidesPerView: 2,
                  spaceBetween: 10
                },
                1024: {
                  slidesPerView: 3,
                  spaceBetween: 10
                },
                1280: {
                  slidesPerView: 5,
                  spaceBetween: 10
                }
              }
            });
    </script>

</body>
</html>

<?php /**PATH C:\xampp\htdocs\litigation\resources\views/frontend/who-we-do.blade.php ENDPATH**/ ?>