

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-sm-12">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0"><?php echo e(isset($blog) ? 'Edit' : 'Create'); ?> Blog</h4>
                </div>
                <div class="card-body">
                    <form method="POST" action="<?php echo e(isset($blog) ? route('admin.blogs.update', $blog) : route('admin.blogs.store')); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                            <ul class="mb-0">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                            </div>
                        <?php endif; ?>
                        <?php if(isset($blog)): ?> <?php echo method_field('PUT'); ?> <?php endif; ?>

                        <div class="form-group mb-3">
                            <label for="title">Title</label>
                            <input type="text" name="title" class="form-control" id="title" value="<?php echo e(old('title', $blog->title ?? '')); ?>" required>
                        </div>

                        <div class="form-group mb-3">
                            <label for="body">Body</label>
                            <textarea name="body" id="body" class="form-control" rows="10"><?php echo e(old('body', $blog->body ?? '')); ?></textarea>
                        </div>

                        <div class="form-group mb-3">
                            <label for="image">Image</label>
                            <input type="file" name="image" class="form-control" onchange="imagePreview(event)" required>
                            <img 
                                id="previewImage" 
                                src="<?php echo e(isset($blog) && $blog->image ? asset($blog->image) : ''); ?>" 
                                style="max-width: 150px; margin-top: 10px; <?php echo e(isset($blog) && $blog->image ? '' : 'display:none;'); ?>"
                                class="img-thumbnail"
                            >
                        </div>

                        <div class="form-group mb-3">
                            <label for="video">Video URL</label>
                            <input type="text" name="video" class="form-control" value="<?php echo e(old('video', $blog->video ?? '')); ?>">
                        </div>

                        <div class="form-group mb-3">
                            <label for="meta_title">Meta Title</label>
                            <input type="text" name="meta_title" class="form-control" value="<?php echo e(old('meta_title', $blog->meta_title ?? '')); ?>">
                        </div>

                        <div class="form-group mb-4">
                            <label for="meta_description">Meta Description</label>
                            <input type="text" name="meta_description" class="form-control" value="<?php echo e(old('meta_description', $blog->meta_description ?? '')); ?>">
                        </div>

                        <button class="btn btn-success w-100"><?php echo e(isset($blog) ? 'Update' : 'Create'); ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- CKEditor 4 Full version -->
<script src="https://cdn.ckeditor.com/4.21.0/full/ckeditor.js"></script>
<script>
    CKEDITOR.replace('body', {
        height: 300
    });

    // function previewImage(event) {
    //     var reader = new FileReader();
    //     reader.onload = function(){
    //         const output = document.getElementById('previewImage');
    //         output.src = reader.result;
    //         output.style.display = 'block';
    //     };
    //     reader.readAsDataURL(event.target.files[0]);
    // }
</script>
<script>
    function imagePreview(event) {
        const file = event.target.files[0];
        const img = new Image();
        const objectUrl = URL.createObjectURL(file);

        img.onload = function () {
            if (img.width !== 1169 || img.height !== 414) {
                alert('Image must be exactly 1169x414 pixels.');
                event.target.value = ''; // reset file input
                document.getElementById('previewImage').style.display = 'none';
            } else {
                const output = document.getElementById('previewImage');
                output.src = objectUrl;
                output.style.display = 'block';
            }
            URL.revokeObjectURL(objectUrl);
        };

        img.src = objectUrl;
    }
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\litigation\resources\views/admin/blog/addedit.blade.php ENDPATH**/ ?>