<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    
    <div class="card shadow-sm">
        <div class="card-header d-flex justify-content-between align-items-center bg-primary text-white">
            <h4 class="mb-0">What We Do List</h4>
            <a href="<?php echo e(route('admin.what-we-do.create')); ?>" class="btn btn-dark btn-sm">+ Add New</a>
        </div>
        <div class="card-body">
            <?php if(session('success')): ?>
                <div class="alert alert-success"><?php echo e(session('success')); ?></div>
            <?php endif; ?>

            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Title</th>
                        <th>Image</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td><?php echo e($item->title); ?></td>
                            <td>
                                <?php if($item->image): ?>
                                    <img src="<?php echo e(asset($item->image)); ?>" width="100">
                                <?php else: ?>
                                    N/A
                                <?php endif; ?>
                            </td>
                            <td>
                                <button class="btn btn-sm <?php echo e($item->status ? 'btn-success' : 'btn-secondary'); ?> toggle-status"
                                    data-id="<?php echo e($item->id); ?>">
                                    <?php echo e($item->status ? 'Active' : 'Inactive'); ?>

                                </button>
                            </td>
                            <td>
                                <a href="<?php echo e(route('admin.what-we-do.edit', $item->slug)); ?>" class="btn btn-sm btn-warning">
                                    <i class="fas fa-edit"></i>
                                </a>

                                <form action="<?php echo e(route('admin.what-we-do.destroy', $item->slug)); ?>" method="POST"
                                    class="d-inline" onsubmit="return confirm('Delete this entry?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger">
                                        <i class="fas fa-trash-alt"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5">No records found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>


<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $('.toggle-status').click(function () {
        const button = $(this);
        const id = button.data('id');

        $.post("<?php echo e(url('admin/what-we-do/status')); ?>/" + id, {
            _token: "<?php echo e(csrf_token()); ?>"
        }, function (res) {
            if (res.status) {
                const isActive = button.text().trim() === 'Active';
                button.toggleClass('btn-success btn-secondary');
                button.text(isActive ? 'Inactive' : 'Active');
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\litigation\resources\views/admin/what_we_do/index.blade.php ENDPATH**/ ?>