<!DOCTYPE html>
<html>
<head>
    <title><?php echo e($blog->title ?? 'Blog Details'); ?></title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php echo $__env->make('frontend.includes.header-link', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>
<body>

<div class="main-body">

    <!-- header -->
    <?php echo $__env->make('frontend.includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- /header -->

    <!-- main content -->
    <div class="main-content">

        <!-- banner starts -->
        <div class="banner-sec" style="background-image: url('<?php echo e(asset('assets/images/about-banner-bg.png')); ?>');">
            <div class="container">
                <div class="banner-wrapper">
                    <div class="blog-details-banner"></div>
                </div>
            </div>
        </div>
        <!-- /banner ends -->

        <!-- blog details starts -->
        <div class="blog-details-sec">
            <div class="container">
                <div class="blog-details-wrapper">
                    <img src="<?php echo e(asset($blog->image)); ?>" class="blog-details-banner" alt="<?php echo e($blog->title); ?>">
                    <div class="blog-details-part">
                        <div class="row">
                            <div class="col-lg-8 col-md-12 col-12">
                                <div class="blog-details-content">
                                    <div class="blog-details-comments d-flex mb-4">
                                        <p>
                                            <img src="<?php echo e(asset('assets/images/user-1.png')); ?>" alt="...">
                                            by <?php echo e($blog->author ?? 'Admin'); ?>

                                        </p>
                                        <!-- <p>
                                            <img src="<?php echo e(asset('assets/images/folder-1.png')); ?>" alt="...">
                                            <?php echo e($blog->category->name ?? 'Uncategorized'); ?>

                                        </p> -->
                                        <p>
                                            <?php echo e($blog->created_at->format('d M Y')); ?>

                                        </p>
                                    </div>
                                    <h2><?php echo e($blog->title); ?></h2>
                                    <h6><?php echo e($blog->short_description); ?></h6>
                                    <p><?php echo $blog->body; ?></p>

                                    <?php if($blog->sub_image): ?>
                                        <img src="<?php echo e(asset('assets/admin/blog-images/' . $blog->sub_image)); ?>" class="sub-banner" alt="...">
                                    <?php endif; ?>

                                    <?php if($blog->sub_heading): ?>
                                        <h5><?php echo e($blog->sub_heading); ?></h5>
                                    <?php endif; ?>
                                    <?php if($blog->sub_content): ?>
                                        <p><?php echo $blog->sub_content; ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <!-- Sidebar -->
                            <div class="col-lg-4 col-md-12 col-12">
                                <div class="blog-details-list">
                                    <div class="blog-details-list-box">
                                        <p>
                                            Welcome to your go-to destination for fresh perspectives. Dive deep into our rich content pool curated meticulously to enlighten, entertain, and engage readers across the globe.
                                        </p>
                                        <div class="blog-details-list-item">
                                            <a href="#"><img src="<?php echo e(asset('assets/images/blog-details-fb.png')); ?>" alt="..."></a>
                                            <a href="#"><img src="<?php echo e(asset('assets/images/blog-details-yt.png')); ?>" alt="..."></a>
                                            <a href="#"><img src="<?php echo e(asset('assets/images/blog-details-insta.png')); ?>" alt="..."></a>
                                            <a href="#"><img src="<?php echo e(asset('assets/images/blog-details-ld.png')); ?>" alt="..."></a>
                                        </div>
                                    </div>

                                    <!-- Featured Posts -->
                                    <div class="blog-details-fp mt-4">
                                        <h5>Featured Posts</h5>
                                        <div class="blog-details-fp-list">
                                            <?php $__currentLoopData = $featuredPosts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="blog-details-fp-list-item d-flex align-items-center">
                                                    <img src="<?php echo e(asset($post->image)); ?>" alt="<?php echo e($post->title); ?>">
                                                    <div class="blog-details-fp-list-content">
                                                        <p>
                                                            <img src="<?php echo e(asset('assets/images/user-1.png')); ?>" alt="...">
                                                            by <?php echo e($post->author ?? 'Admin'); ?>

                                                        </p>
                                                       
                                                            
                                                        
                                                        <a href="<?php echo e(route('blogs.show', $post->slug)); ?>">
                                                            <h6> <?php echo e(Str::limit($post->title, 50)); ?> </h6>
                                                        </a>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- /Sidebar -->
                        </div>

                        <!-- Related Blogs -->
                        <div class="blog-sec pb-0">
                            <div class="heading-sec d-flex align-items-end justify-content-between mb-0 pl-3">
                                <div class="heading-text">
                                    <h3>You Also Like</h3>
                                    <p class="mb-0">Discover more articles related to this topic.</p>
                                </div>
                            </div>

                            <div class="blog-wrspper">
                                <div class="row">
                                    <?php $__currentLoopData = $relatedPosts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-lg-4 col-md-4 col-12">
                                            <div class="blog-item">
                                                <div class="blog-item-img-heading">
                                                    <img src="<?php echo e(asset($post->image)); ?>" alt="<?php echo e($post->title); ?>">
                                                    <div class="blog-item-heading">
                                                        <div class="d-flex align-items-center mb-3">
                                                            <p class="mr-2">
                                                                <img src="<?php echo e(asset('assets/images/blog-user-icon.png')); ?>" alt="">
                                                                by <?php echo e($post->author ?? 'Admin'); ?>

                                                            </p>
                                                            <p>
                                                                <img src="<?php echo e(asset('assets/images/blog-folder-icon.png')); ?>" alt="">
                                                                <?php echo e($post->category->name ?? 'Blog'); ?>

                                                            </p>
                                                        </div>
                                                        <h6>
                                                            <!-- <?php echo e(Str::limit($post->title, 50)); ?> -->
                                                        <?php echo e(\Illuminate\Support\Str::limit($post->title, 50)); ?>

                                                        </h6>
                                                        <p class="date-p">
                                                            <?php echo e($post->created_at->format('d')); ?><br>
                                                            <span><?php echo e($post->created_at->format('M')); ?></span>
                                                        </p>
                                                    </div>
                                                </div>
                                                <p class="mb-4">
                                                    <!-- <?php echo e(Str::limit(strip_tags($post->body), 150)); ?> -->
                                                    <?php echo e(\Illuminate\Support\Str::limit(strip_tags($post->body), 150)); ?>

                                                </p>
                                                <a href="<?php echo e(route('blogs.show', $post->slug)); ?>">
                                                    <img src="<?php echo e(asset('assets/images/arrow.png')); ?>" alt="...">
                                                    <span>Read More</span>
                                                </a>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                        <!-- /Related Blogs -->

                    </div>
                </div>
            </div>
        </div>
        <!-- /blog details ends -->

    </div>
    <!-- /main content -->

    <!-- footer -->
    <?php echo $__env->make('frontend.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- /footer -->

</div>

<?php echo $__env->make('frontend.includes.footer-link', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\litigation\resources\views/frontend/blog-details.blade.php ENDPATH**/ ?>