

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-sm-12">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0"><?php echo e($testimonial->id ? 'Edit' : 'Add'); ?> Testimonial</h4>
                </div>

                <div class="card-body">
                    <form method="POST" 
                          action="<?php echo e($testimonial->id ? route('admin.testimonials.update', $testimonial->id) : route('admin.testimonials.store')); ?>" 
                          enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php if($testimonial->id): ?>
                            <?php echo method_field('PUT'); ?>
                        <?php endif; ?>

                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>

                        <div class="form-group mb-3">
                            <label for="name">Name <span class="text-danger">*</span></label>
                            <input type="text" name="name" class="form-control" id="name" value="<?php echo e(old('name', $testimonial->name)); ?>" required>
                        </div>

                        <div class="form-group mb-3">
                            <label for="designation">Designation</label>
                            <input type="text" name="designation" class="form-control" id="designation" value="<?php echo e(old('designation', $testimonial->designation)); ?>">
                        </div>

                        <div class="form-group mb-3">
                            <label for="message">Message <span class="text-danger">*</span></label>
                            <textarea name="message" id="message" class="form-control" rows="5" required><?php echo e(old('message', $testimonial->message)); ?></textarea>
                        </div>

                        <div class="form-group mb-3">
                            <label for="image">Image (optional)</label>
                            <input type="file" name="image" class="form-control" onchange="imagePreview(event)">
                            <img 
                                id="previewImage" 
                                src="<?php echo e($testimonial->image ? asset($testimonial->image) : ''); ?>" 
                                style="max-width: 150px; margin-top: 10px; <?php echo e($testimonial->image ? '' : 'display:none;'); ?>"
                                class="img-thumbnail"
                            >
                        </div>

                        <button type="submit" class="btn btn-success w-100">
                            <?php echo e($testimonial->id ? 'Update' : 'Add'); ?> Testimonial
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function imagePreview(event) {
        const file = event.target.files[0];
        const output = document.getElementById('previewImage');
        if (!file) return;

        const reader = new FileReader();
        reader.onload = function () {
            output.src = reader.result;
            output.style.display = 'block';
        };
        reader.readAsDataURL(file);
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\litigation\resources\views/admin/testimonials/addedit.blade.php ENDPATH**/ ?>