<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\Admin\BlogController;
use App\Http\Controllers\Admin\AboutController;
use App\Http\Controllers\Admin\TestimonialController;
use App\Http\Controllers\Admin\WhoWeHelpController;
use App\Http\Controllers\Admin\ContactUsController;
use App\Http\Controllers\Admin\WhatWeDoController;
use App\Http\Controllers\Frontend\FrontendBlogController;
use App\Http\Controllers\Frontend\FrontendAboutController;
use App\Http\Controllers\Frontend\FrontendContactController;
use App\Http\Controllers\Frontend\FrontendHomeController;
use App\Http\Controllers\Frontend\FrontEndController;
use App\Http\Controllers\Frontend\FrontendClientconsultancyController;
// Frontend route
Route::get('/', [FrontendHomeController::class, 'index'])->name('home');

//who we help
Route::get('/who-we-help/{slug}', [FrontendHomeController::class, 'show'])->name('who-we-help.show');
Route::get('/who-we-help-list', [FrontendHomeController::class, 'WhowehelpList'])->name('frontend.who-we-help.list');

//client consultancy
// Route::view('/client-consultancy', 'frontend.client-consultancy');
Route::get('/client-consultancy', [FrontendClientconsultancyController::class, 'clientConsultancy'])->name('clientConsultancy');

//Blogs
Route::get('/blogs', [FrontendBlogController::class, 'index'])->name('blogs.index');
Route::get('/blogs/{slug}', [FrontendBlogController::class, 'show'])->name('blogs.show');

//About us
Route::get('/about-us', [FrontendAboutController::class, 'index'])->name('about');

//contact us
Route::get('/contact-us', [FrontendContactController::class, 'contactForm'])->name('contact');
Route::post('/contact-submit', [FrontendContactController::class, 'store'])->name('contact.submit');

//what we do
Route::get('/what-we-do', [FrontEndController::class, 'WhatWeDo'])->name('whatwedo');
Route::get('/what-we-do/{slug?}', [FrontEndController::class, 'WhatWeDo_Details'])->name('frontend.what-we-do.show');
Route::get('/what-we-do-list', [FrontEndController::class, 'WhatWeDoList'])->name('frontend.what-we-do.list');
// Frontend route




// Authenticated user dashboard
Route::get('/dashboard', function () {
    return view('admin.dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

// Profile routes (only for authenticated users)
Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

// Admin-only dashboard route
Route::middleware(['auth', 'is_admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [AdminController::class, 'index'])->name('dashboard');

    Route::get('blogs', [BlogController::class, 'index'])->name('blogs.index');          // List all blogs
    Route::get('blogs/create', [BlogController::class, 'create'])->name('blogs.create'); // Show form to create
    Route::post('blogs', [BlogController::class, 'store'])->name('blogs.store');         // Save new blog
    Route::get('blogs/{blog}/edit', [BlogController::class, 'edit'])->name('blogs.edit');    // Show edit form
    Route::put('blogs/{blog}', [BlogController::class, 'update'])->name('blogs.update');     // Update blog
    Route::delete('blogs/{blog}', [BlogController::class, 'destroy'])->name('blogs.destroy'); // Delete blog

    // About Us - Static Page Routes
    Route::get('about', [AboutController::class, 'index'])->name('about.index');       // View current content
    Route::get('about/edit', [AboutController::class, 'edit'])->name('about.edit');    // Edit form
    Route::put('about/update', [AboutController::class, 'update'])->name('about.update'); // Update content

    // Testimonial Routes
    Route::get('testimonials', [TestimonialController::class, 'index'])->name('testimonials.index');         // List all
    Route::get('testimonials/create', [TestimonialController::class, 'create'])->name('testimonials.create'); // Show create form
    Route::post('testimonials', [TestimonialController::class, 'store'])->name('testimonials.store');         // Store new
    Route::get('testimonials/{testimonial}/edit', [TestimonialController::class, 'edit'])->name('testimonials.edit');   // Edit form
    Route::put('testimonials/{testimonial}', [TestimonialController::class, 'update'])->name('testimonials.update');     // Update
    Route::delete('testimonials/{testimonial}', [TestimonialController::class, 'destroy'])->name('testimonials.destroy');// Delete

    // Who WE help Routes
    Route::get('whowehelp', [WhoWeHelpController::class, 'index'])->name('whowehelp.index');
    Route::get('whowehelp/create', [WhoWeHelpController::class, 'create'])->name('whowehelp.create');
    Route::get('whowehelp/{whowehelp}/edit', [WhoWeHelpController::class, 'edit'])->name('whowehelp.edit');
    Route::post('whowehelp/storeOrUpdate/{id?}', [WhoWeHelpController::class, 'storeOrUpdate'])->name('whowehelp.storeOrUpdate');
    Route::delete('whowehelp/{whowehelp}', [WhoWeHelpController::class, 'destroy'])->name('whowehelp.destroy');

    // Contact-us Routes
    Route::get('contact-us', [ContactUsController::class, 'index'])->name('contact-us.index');
    Route::get('contact-us/create', [ContactUsController::class, 'show'])->name('contact-us.create');
    Route::post('contact-us', [ContactUsController::class, 'store'])->name('contact-us.store');  
    Route::get('contact-us/{id}/edit', [ContactUsController::class, 'edit'])->name('contact-us.edit'); 
    Route::put('contact-us/{id}', [ContactUsController::class, 'update'])->name('contact-us.update'); 
    Route::delete('contact-us/{id}', [ContactUsController::class, 'destroy'])->name('contact-us.destroy');

    //what we do
    Route::get('what-we-do/create', [WhatWeDoController::class, 'createFrom'])->name('what-we-do.create');
    Route::post('what-we-do/store', [WhatWeDoController::class, 'store'])->name('what-we-do.store');
    Route::get('what-we-do', [WhatWeDoController::class, 'index'])->name('what-we-do.index');
    Route::get('what-we-do/edit/{slug}', [WhatWeDoController::class, 'edit'])->name('what-we-do.edit');
    Route::put('what-we-do/update/{id}', [WhatWeDoController::class, 'update'])->name('what-we-do.update');
    Route::delete('what-we-do/delete/{slug}', [WhatWeDoController::class, 'destroy'])->name('what-we-do.destroy');
    Route::post('what-we-do/status/{id}', [WhatWeDoController::class, 'toggleStatus'])->name('what-we-do.toggleStatus');


});

// Include authentication routes (login, register, etc.)
require __DIR__.'/auth.php'; 
