
<!DOCTYPE html>
<html>
<head>
    <title>{{ $item->title }}</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    @include('frontend.includes.header-link')

    <style>
        .about-who-we-help-sec div.about-who-we-help-content p {
            margin-bottom: 20px;
        }
        .about-who-we-help-sec.service-deatils-sec {
            padding-bottom: 30px;
        }
        .service-deatils-sec h5 {
            font-size: 33px;
            font-family: "Pratt Nova Light", serif;
            margin-bottom: 20px;
            line-height: 100%;
            font-weight: 300;
        }
        .service-deatils-sec h6 {
            font-size: 22px;
            font-weight: 300;
            margin-bottom: 10px;
        }
        .service-deatils-sec p {
            font-size: 16px !important;
            font-weight: 200 !important;
            margin-bottom: 20px !important;
            line-height: 28px !important;
        }
        .service-deatils-sec .about-who-we-help-content ul {
            margin-left: 15px;
            margin-bottom: 20px;
        }
        .service-deatils-sec .about-who-we-help-content li {
            padding: 5px 5px 5px 20px;
            font-size: 14px;
            line-height: 20px;
            border: 0px;
            font-weight: 200;
        }
        .service-deatils-sec .about-who-we-help-content li::after {
            content: "";
            width: 7px;
            height: 7px;
            background-image: none;
            position: absolute;
            left: 0;
            top: 50%;
            transform: translateY(-50%);
            background-color: white;
            border-radius: 50%;
        }
    </style>

</head>
<body>

    <!-- <div id="loader"></div> -->

    <div class="main-body" >

        <!-- header -->
        @include('frontend.includes.header')
        <!-- /header -->

        <!-- main content -->
        <div class="main-content">

            <!-- banner starts -->
            <div class="banner-sec" style="background-image: url('{{ asset('assets/images/about-banner-bg.png') }}');">
                <div class="container">
                    <div class="banner-wrapper">
                        <h1>
                        {{ $item->title }}
                        </h1>
                        
                        <div class="scroll-div d-flex align-items-center justify-content-center">
                            <p>
                                scroll down
                                <br><br>
                                <img src="{{ asset('assets/images/fi_6364586.png') }}" alt="...">
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /banner ends -->

            <!-- Who We Help starts -->
            <div class="about-who-we-help-sec service-deatils-sec">
                <div class="container">
                    <div class="about-who-we-help-wrapper">
                        <div class="row align-items-center">
                            <div class="col-lg-5 col-md-5 col-12">
                                <div class="about-who-we-help-image">
                                     <img src="{{ asset($item->image) }}" alt="{{ $item->title }}">
                                </div>
                            </div>
                            <div class="col-lg-7 col-md-7 col-12">
                                <div class="about-who-we-help-content">
                                    <h5>
                                        {{ $item->title }}
                                    </h5>
                                    <h6>
                                        <b>{{ $item->subtitle }}</b>
                                    </h6>
                                    <p>
                                        {{ $item->short_description }}
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="about-who-we-help-content mt-5">
                            {!! html_entity_decode($item->body) !!}
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Who We Help ends -->

            <!-- other services starts -->
            

            <div class="who-we-help-sec">
                <div class="container">
                    <div class="heading-sec d-flex align-items-center justify-content-between">
                        <div class="heading-text">  
                            <h3>
                                Who We Help
                            </h3>
                            <p>
                            At LitigationFundings.com, we don’t just provide capital. We unlock possibilities. Our solutions are purpose-built for stakeholders across the legal and financial spectrum, enabling them to pursue high-value, high-stakes disputes without financial compromise. Explore who we serve:
                            </p>
                        </div>
                        <div class="heading-button">
                            <a href="#" class="d-flex align-items-center">
                                <img src="{{ asset('assets/images/arrow.png') }}" alt="...">
                                <span>
                                    View All Categories
                                </span>
                            </a>
                        </div>
                    </div>
                    <div class="who-we-help-wrapper">
                        <div class="swiper who-we-help-slider">
                            <div class="swiper-wrapper">
                              
                            @foreach($alldata as $value)
                                <div class="swiper-slide swiper-slide-active" role="group" aria-label="1 / 4" data-swiper-slide-index="0" style="width: 383px; margin-right: 10px;">
                                    <div class="who-we-help-item">
                                    <img src="{{ asset($value->image) }}" alt="{{ $value->title }}">
                                    <h5>{{ \Illuminate\Support\Str::limit($value->title, 28) }}</h5>
                                        <h6> {{ $value->subtitle }}</h6>
                                        <p>{{ \Illuminate\Support\Str::words(html_entity_decode(strip_tags($value->short_description)), 20, '...') }}</p>
                                        <a href="{{ route('who-we-help.show', $value->slug) }}">
                                            <img src="{{ asset('assets/images/arrow.png') }}" alt="...">
                                            <span>
                                                View Details
                                            </span>
                                        </a>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                            <div class="swiper-pagination"></div>
                        </div>
                        <div class="slider-controls">
                            <div class="swiper-button-prev"></div>
                            <div class="swiper-button-next"></div>
                        </div>
                    </div>
                </div>
            </div>
            
        </div>
        <!-- /main content -->

        <!-- footer -->
        @include('frontend.includes.footer')
        <!-- /footer -->
        
    </div>

    @include('frontend.includes.footer-link')

</body>
</html>

