
<!DOCTYPE html>
<html>
<head>
    <title>Home</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    @include('frontend.includes.header-link')

</head>
<body>

    <!-- <div id="loader"></div> -->

    <div class="main-body" >

        <!-- header -->
       
        @include('frontend.includes.header')
        <!-- /header -->

        <!-- main content -->
        <div class="main-content">

            <!-- banner starts -->
            <div class="banner-sec" style="background-image: url(assets/images/banner-bg.jpg);">
                <div class="container">
                    <div class="banner-wrapper">
                        <h1>
                            Financial Support for Legal Disputes
                        </h1>
                        <p>
                            We pay for all litigation costs on the litigant's behalf.
                        </p>
                        <div class="banner-email-phone d-flex">
                            <div class="d-flex align-items-center">
                                <img src="assets/images/banner-call-icon.png" alt="...">
                                <a href="tel:(239) 555-0108">(239) 555-0108</a>
                            </div>
                            <div class="d-flex align-items-center">
                                <img src="assets/images/banner-email-icon.png" alt="...">
                                <a href="mailto:georgia.young@example.com">georgia.young@example.com</a>
                            </div>
                        </div>
                        <div class="banner-btn d-flex">
                            <button class="main-btn-black">Contact us</button>
                            <button class="main-btn-white">Apply For Funding</button>
                        </div>
                        <div class="scroll-div d-flex align-items-center justify-content-center">
                            <p>
                                scroll down
                                <br><br>
                                <img src="assets/images/fi_6364586.png" alt="...">
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /banner ends -->

            <!-- Who We Help starts -->
            <div class="who-we-help-sec">
                <div class="container">
                    <div class="heading-sec d-flex align-items-center justify-content-between">
                        <div class="heading-text">  
                            <h3>
                                Who We Help
                            </h3>
                            <p>
                            At LitigationFundings.com, we don’t just provide capital. We unlock possibilities. Our solutions are purpose-built for stakeholders across the legal and financial spectrum, enabling them to pursue high-value, high-stakes disputes without financial compromise. Explore who we serve:
                            </p>
                        </div>
                        <div class="heading-button">
                            <a href="{{ route('frontend.who-we-help.list') }}" class="d-flex align-items-center">
                                <img src="assets/images/arrow.png" alt="...">
                                <span>
                                    View All Categories
                                </span>
                            </a>
                        </div>
                    </div>
                    <div class="who-we-help-wrapper">
                        <div class="swiper who-we-help-slider">
                            <div class="swiper-wrapper">
                              
                            @foreach($whoWeHelpItems as $item)
                                <div class="swiper-slide">
                                    <div class="who-we-help-item">
                                        <img src="{{ asset($item->image) }}" alt="{{ $item->title }}">
                                        <h5>{{ \Illuminate\Support\Str::limit($item->title, 28) }}</h5>
                                        <h6>{{ $item->subtitle }}</h6>
                                        <p>{{ \Illuminate\Support\Str::words(html_entity_decode(strip_tags($item->short_description)), 20, '...') }}</p>
                                        <a href="{{ route('who-we-help.show', $item->slug) }}">
                                            <img src="{{ asset('assets/images/arrow.png') }}" alt="...">
                                            <span>View Details</span>
                                        </a>
                                    </div>
                                </div>
                            @endforeach
                            </div>
                            <div class="swiper-pagination"></div>
                        </div>
                        <div class="slider-controls">
                            <div class="swiper-button-prev"></div>
                            <div class="swiper-button-next"></div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Who We Help ends -->

            <!-- Why litigation funding starts -->
            <div class="why-litigation-funding-sec">
                <div class="container">
                    <div class="heading-sec">
                        <div class="heading-text text-center">  
                            <h3>
                                Why litigation funding
                            </h3>
                            <p>
                                Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,
                            </p>
                        </div>
                    </div>
                    <div class="why-litigation-funding-wrapper">
                        <div class="row">
                            <div class="col-lg-3 col-md-6 col-12">
                                <div class="why-litigation-funding-item text-center">
                                    <img src="assets/images/why-litigation-funding-1.png" alt="...">
                                    <h6>
                                        Financial Relief
                                    </h6>
                                    <p>
                                        Litigation funding offers quick relief by covering legal and court-related costs.
                                    </p>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-6 col-12">
                                <div class="why-litigation-funding-item text-center">
                                    <img src="assets/images/why-litigation-funding-2.png" alt="...">
                                    <h6>
                                        Leveling the Playing Field
                                    </h6>
                                    <p>
                                        Litigation funding removes financial barriers in legal battles.
                                    </p>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-6 col-12">
                                <div class="why-litigation-funding-item text-center">
                                    <img src="assets/images/why-litigation-funding-3.png" alt="...">
                                    <h6>
                                        Top Legal Representation
                                    </h6>
                                    <p>
                                        Litigation funding enables hiring top attorneys for expert case handling.
                                    </p>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-6 col-12">
                                <div class="why-litigation-funding-item text-center">
                                    <img src="assets/images/why-litigation-funding-4.png" alt="...">
                                    <h6>
                                        Win-Win Outcome
                                    </h6>
                                    <p>
                                        Litigants receive fair compensation; funders get a set share of the damages.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Why litigation funding ends -->

            <!-- blags starts -->
            <div class="blog-sec">
                <div class="container">
                    <div class="heading-sec d-flex align-items-center justify-content-between">
                        <div class="heading-text">  
                            <h3>
                                Our Recent Blogs
                            </h3>
                            <!-- <p>
                                Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt
                            </p> -->
                        </div>
                        <div class="heading-button">
                            <a href="{{ url('/blogs') }}" class="d-flex align-items-center">
                                <img src="assets/images/arrow.png" alt="...">
                                <span>
                                    View All Blogs
                                </span>
                            </a>
                        </div>
                    </div>
                    <div class="blog-wrspper">
                        <div class="row">
                            @foreach($blogs as $blog)
                                <div class="col-lg-4 col-md-6 col-12">
                                    <div class="blog-item">
                                        <div class="blog-item-img-heading">
                                            <img src="{{ asset($blog->image) }}" alt="{{ $blog->title }}">
                                            <div class="blog-item-heading">
                                                <div class="d-flex align-items-center mb-3">
                                                    <p class="mr-2">
                                                        <img src="{{ asset('assets/images/blog-user-icon.png') }}" alt="">
                                                        by Admin
                                                    </p>
                                                    <p>
                                                        <img src="{{ asset('assets/images/blog-folder-icon.png') }}" alt="">
                                                        Blog
                                                    </p>
                                                </div>
                                                <h6>{{ \Illuminate\Support\Str::limit($blog->title, 50) }}</h6>
                                                <p class="date-p">
                                                    {{ \Carbon\Carbon::parse($blog->created_at)->format('d') }} <br>
                                                    <span>{{ \Carbon\Carbon::parse($blog->created_at)->format('M') }}</span>
                                                </p>
                                            </div>
                                        </div>
                                        <p class="mb-4">
                                            {{ \Illuminate\Support\Str::limit(strip_tags($blog->body), 150) }}
                                        </p>
                                        <a href="{{ route('blogs.show', $blog->slug) }}">
                                            <img src="{{ asset('assets/images/arrow.png') }}" alt="...">
                                            <span>Read More</span>
                                        </a>
                                    </div>
                                </div>
                            @endforeach
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- /blags ends -->

            <!-- review starts -->
            <div class="review-sec">
                <div class="container">
                    <div class="heading-sec">
                        <div class="heading-text text-center">  
                            <h3>
                                What our clients says?
                            </h3>
                        </div>
                    </div>
                    <div class="review-wrapper">
                        <div class="row">
                        @foreach($testimonials as $testimonial)
                            <div class="col-lg-4 col-md-6 col-12">
                                <div class="review-item">
                                    <div class="d-flex align-items-center">
                                        <img src="{{ asset($testimonial->image) }}" alt="...">
                                        <div class="review-name">
                                            <h6>
                                           {{ $testimonial->name}}
                                            </h6>
                                            <p>
                                            {{ $testimonial->designation}}
                                            </p>
                                        </div>
                                    </div>
                                    <p>
                                    {{ $testimonial->message}}
                                    </p>
                                </div>
                            </div>
                        @endforeach
                        </div>
                    </div>
                </div>
            </div>
            <!-- /review ends -->
            
        </div>
        <!-- /main content -->

        <!-- footer -->
        @include('frontend.includes.footer')
        <!-- /footer -->
        
    </div>
    @include('frontend.includes.footer-link')
</body>
</html>

