
<!DOCTYPE html>
<html>
<head>
    <title>Contact Us</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    @include('frontend.includes.header-link')

</head>
<body>

    <!-- <div id="loader"></div> -->

    <div class="main-body" >

        <!-- header -->
        @include('frontend.includes.header')
        <!-- /header -->

        <!-- main content -->
        <div class="main-content">

            <!-- banner starts -->
            <div class="banner-sec" style="background-image: url(assets/images/about-banner-bg.png);">
                <div class="container">
                    <div class="banner-wrapper">
                        <h1>
                            Contact Us
                        </h1>
                        <p>
                           
                        </p>
                        <div class="scroll-div d-flex align-items-center justify-content-center">
                            <p>
                                scroll down
                                <br><br>
                                <img src="assets/images/fi_6364586.png" alt="...">
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /banner ends -->

            <!-- contact info starts -->
            <div class="contact-info-sec">
                <div class="container">
                    <div class="contact-info-wrapper">
                        <div class="row">
                            <div class="col-lg-4 col-md-4 col-12">
                                <div class="contact-info-item text-center">
                                    <img src="assets/images/contact-call-icon.png" alt="...">
                                    <h4>
                                        Call us
                                    </h4>
                                    <p>
                                        Fill in the form below or call 
                                        <br>
                                        <a href="tel:2222223333">222 222 3333</a> 
                                    </p>
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-4 col-12">
                                <div class="contact-info-item text-center">
                                    <img src="assets/images/contact-email-icon.png" alt="...">
                                    <h4>
                                        Email us
                                    </h4>
                                    <p>
                                        Mail us for any type of help 
                                        <br>
                                        <a href="mailto:litigaton@funding.com">litigaton@funding.com</a> 
                                    </p>
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-4 col-12">
                                <div class="contact-info-item text-center">
                                    <img src="assets/images/contact-location-icon.png" alt="...">
                                    <h4>
                                        Locations
                                    </h4>
                                    <p>
                                        B-35, Lower Ground Floor South <br>
                                        Extension Part 2, New Delhi, 110049
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /contact info sec ends -->

            <!-- contact from sec starts -->
            <div class="claim-now-sec contact-from-sec">
                <div class="container">
                    <div class="claim-now-wrapper">
                        <div class="row">
                            <div class="col-lg-6 col-md-6 col-12">
                                <div class="claim-now-text">
                                    <div class="heading-text-sec">
                                        <div class="heading-sec">
                                            <div class="heading-text">  
                                                <h3>
                                                    Submit Your Query
                                                </h3>
                                                <p>
                                                    Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt Lorem ipsum dolor sit amet
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <img src="assets/images/about-claim-now.png" alt="...">
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-12">
                                <div class="claim-now-form">
                                    <h5>
                                        find Out the Form Below
                                    </h5>
                                    @if(session('success'))
                                        <div class="alert alert-success" style="color: green; margin-bottom: 20px;">
                                            {{ session('success') }}
                                        </div>
                                    @endif
                                    @if ($errors->any())
                                        <div class="alert alert-danger">
                                            <ul style="margin: 0; padding-left: 20px;">
                                                @foreach ($errors->all() as $error)
                                                    <li>{{ $error }}</li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    @endif

                                    @error('captcha')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                    <form action="{{ route('contact.submit') }}" method="POST">
                                        @csrf
                                        <div class="form-item">
                                            <label>Name</label>
                                            <input type="text" name="name" placeholder="Enter your Name">
                                        </div>
                                        <div class="form-item">
                                            <label>Email</label>
                                            <input type="text" name="email" placeholder="Enter your Email">
                                        </div>
                                        <div class="form-item">
                                            <label>Phone</label>
                                            <input type="text" name="phone" placeholder="Enter Your Phone">
                                        </div>
                                        <div class="form-item">
                                            <label>City</label>
                                            <input type="text" name="city" placeholder="Enter Your City">
                                        </div>
                                        <div class="form-item w-100">
                                            <label>Please select the Nature of Work / Money to be recovered</label>
                                            <br><br>
                                            <div class="checkbox-input-div">
                                                @foreach($natureOfInvestments as $investment)
                                                    <label class="checkbox-input-label">
                                                        <input type="checkbox" class="checkbox-input" name="nature_of_work[]" value="{{ $investment->id }}">
                                                        {{ $investment->name }}
                                                    </label>
                                                @endforeach

                                            </div>
                                        </div>
                                        <div class="g-recaptcha" data-sitekey="{{ config('services.recaptcha.site_key') }}"></div>
                                        <div class="form-item">
                                            <button type="submit">Submit</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /contact from sec ends -->
            
        </div>
        <!-- /main content -->

        <!-- footer -->
        @include('frontend.includes.footer')
        <!-- /footer -->
        
    </div>
    @include('frontend.includes.footer-link')
<!-- Include reCAPTCHA script -->
<script src="https://www.google.com/recaptcha/api.js" async defer></script>
</body>
</html>

