
<!DOCTYPE html>
<html>
<head>
    <title>Client Consultancy</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    @include('frontend.includes.header-link')

</head>
<body>

    <!-- <div id="loader"></div> -->

    <div class="main-body" >

        <!-- header -->
        @include('frontend.includes.header')
        <!-- /header -->

        <!-- main content -->
        <div class="main-content">

            <!-- banner starts -->
            <div class="banner-sec" style="background-image: url(assets/images/about-banner-bg.png);">
                <div class="container">
                    <div class="banner-wrapper">
                        <h1>
                            Client Consultancy
                        </h1>
                        <p>
                            
                        </p>
                        <div class="scroll-div d-flex align-items-center justify-content-center">
                            <p>
                                scroll down
                                <br><br>
                                <img src="assets/images/fi_6364586.png" alt="...">
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /banner ends -->

            <!-- Who We Help starts -->
            <div class="about-who-we-help-sec client-consultancy-sec-1">
                <div class="container">
                    <div class="about-who-we-help-wrapper">
                        <div class="row align-items-center">
                            <div class="col-lg-6 col-md-6 col-12">
                                <div class="about-who-we-help-image">
                                    <img src="assets/images/about-claim-now-1.jpg" alt="...">
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-12">
                                <div class="about-who-we-help-content">
                                    <h3>
                                        Personalized Guidance for Every Financial Recovery Journey
                                    </h3>
                                    <p>
                                        At Litigation fundings, we understand that navigating the world of unclaimed investments, legal disputes, and financial recovery can be complex and overwhelming. That’s why our Client Consultancy Services are designed to offer dedicated, expert-driven support tailored to your specific situation.
                                        <br><br>
                                        Whether you’re reclaiming lost investments, dealing with share transfers, or seeking advice on legal funding—we’re here to guide you every step of the way.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Who We Help ends -->

            <!-- Benefits of Funding starts -->
            <div class="why-litigation-funding-sec">
                <div class="container">
                    <div class="heading-sec">
                        <div class="heading-text text-center">  
                            <h3>
                                What We Offer
                            </h3>
                            <p>
                                Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,
                            </p>
                        </div>
                    </div>
                    <div class="why-litigation-funding-wrapper">
                        <div class="row">
                            <div class="col-lg-3 col-md-3 col-6">
                                <div class="why-litigation-funding-item text-center">
                                    <img src="assets/images/why-litigation-funding-1.png" alt="...">
                                    <h6>
                                        Financial Relief
                                    </h6>
                                    <p>
                                        Litigation funding offers quick relief by covering legal and court-related costs.
                                    </p>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-3 col-6">
                                <div class="why-litigation-funding-item text-center">
                                    <img src="assets/images/why-litigation-funding-2.png" alt="...">
                                    <h6>
                                        Leveling the Playing Field
                                    </h6>
                                    <p>
                                        Litigation funding removes financial barriers in legal battles.
                                    </p>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-3 col-6">
                                <div class="why-litigation-funding-item text-center">
                                    <img src="assets/images/why-litigation-funding-3.png" alt="...">
                                    <h6>
                                        Top Legal Representation
                                    </h6>
                                    <p>
                                        Litigation funding enables hiring top attorneys for expert case handling.
                                    </p>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-3 col-6">
                                <div class="why-litigation-funding-item text-center">
                                    <img src="assets/images/why-litigation-funding-4.png" alt="...">
                                    <h6>
                                        Win-Win Outcome
                                    </h6>
                                    <p>
                                        Litigants receive fair compensation; funders get a set share of the damages.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Benefits of Funding ends -->

            <!-- Who We Help starts -->
            <div class="about-who-we-help-sec client-consultancy-sec-1">
                <div class="container">
                    <div class="about-who-we-help-wrapper">
                        <div class="row align-items-center">
                            <div class="col-lg-6 col-md-6 col-12">
                                <div class="about-who-we-help-content">
                                    <h3>
                                        Who Should Reach Out?
                                    </h3>
                                    <ul>
                                        <li>
                                            Legal heirs or nominees of unclaimed investments
                                        </li>
                                        <li>
                                            Investors seeking to recover forgotten or unclaimed assets
                                        </li>
                                        <li>
                                            Legal heirs or nominees of unclaimed investments
                                        </li>
                                        <li>
                                            Individuals struggling with share transmission or duplicate issues
                                        </li>
                                        <li>
                                            Clients involved in financial disputes or seeking litigation funding
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-lg-1 col-md-1 col-12"></div>
                            <div class="col-lg-5 col-md-5 col-12">
                                <div class="about-who-we-help-image">
                                    <img src="assets/images/who-should-reach-out.jpg" alt="...">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Who We Help ends -->

            <!-- Why Choose Us? -->
            <div class="review-sec why-choose-us-sec">
                <div class="container">
                    <div class="heading-sec">
                        <div class="heading-text text-center">  
                            <h3>
                                Why Choose Us?
                            </h3>
                        </div>
                    </div>
                    <div class="review-wrapper">
                        <div class="row">
                            <div class="col-lg-3 col-md-3 col-12">
                                <div class="review-item">
                                    <div class="d-flex align-items-center">
                                        <img src="assets/images/why-choose-us-1.png" alt="...">
                                        <div class="review-name">
                                            <h6>
                                                Trusted Platform
                                            </h6>
                                        </div>
                                    </div>
                                    <p>
                                        Backed by a strong track record in recovery services
                                    </p>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-3 col-12">
                                <div class="review-item">
                                    <div class="d-flex align-items-center">
                                        <img src="assets/images/why-choose-us-2.png" alt="...">
                                        <div class="review-name">
                                            <h6>
                                                Confidential & Compliant
                                            </h6>
                                        </div>
                                    </div>
                                    <p>
                                        our data is safe and your rights protected
                                    </p>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-3 col-12">
                                <div class="review-item">
                                    <div class="d-flex align-items-center">
                                        <img src="assets/images/why-choose-us-3.png" alt="...">
                                        <div class="review-name">
                                            <h6>
                                                Pan-India Reach
                                            </h6>
                                        </div>
                                    </div>
                                    <p>
                                        Serving clients across geographies with local expertise
                                    </p>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-3 col-12">
                                <div class="review-item">
                                    <div class="d-flex align-items-center">
                                        <img src="assets/images/why-choose-us-4.png" alt="...">
                                        <div class="review-name">
                                            <h6>
                                                Results-Driven Approach
                                            </h6>
                                        </div>
                                    </div>
                                    <p>
                                        Focused on outcomes, not just consultations
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Why Choose Us? -->

            <!-- Claim Now starts -->
            <div class="claim-now-sec">
                <div class="container">
                    <div class="claim-now-wrapper">
                        <div class="row">
                            <div class="col-lg-6 col-md-6 col-12">
                                <div class="claim-now-text">
                                    <div class="heading-text-sec">
                                        <div class="heading-sec">
                                            <div class="heading-text">  
                                                <h3>
                                                    Claim Now
                                                </h3>
                                                <p>
                                                    Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt Lorem ipsum dolor sit amet
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <p>
                                        Call Now  <a href="tel:2222223333">222 222 3333</a> 
                                    </p>
                                    <img src="assets/images/about-claim-now.png" alt="...">
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-12">
                                <div class="claim-now-form">
                                    <h5>
                                        find Out the Form Below
                                    </h5>
                                    @if(session('success'))
                                        <div class="alert alert-success" style="color: green; margin-bottom: 20px;">
                                            {{ session('success') }}
                                        </div>
                                    @endif
                                    @if ($errors->any())
                                        <div class="alert alert-danger">
                                            <ul style="margin: 0; padding-left: 20px;">
                                                @foreach ($errors->all() as $error)
                                                    <li>{{ $error }}</li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    @endif

                                    @error('captcha')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                    <form action="{{ route('contact.submit') }}" method="POST">
                                        @csrf
                                        <div class="form-item">
                                            <label>Name</label>
                                            <input type="text" name="name" placeholder="Enter your Name">
                                        </div>
                                        <div class="form-item">
                                            <label>Email</label>
                                            <input type="text" name="email" placeholder="Enter your Email">
                                        </div>
                                        <div class="form-item">
                                            <label>Phone</label>
                                            <input type="text" name="phone" placeholder="Enter Your Phone">
                                        </div>
                                        <div class="form-item">
                                            <label>City</label>
                                            <input type="text" name="city" placeholder="Enter Your City">
                                        </div>
                                        <div class="form-item w-100">
                                            <label>Please select the Nature of Work / Money to be recovered</label>
                                            <br><br>
                                            <div class="checkbox-input-div">
                                                @foreach($natureOfInvestments as $investment)
                                                    <label class="checkbox-input-label">
                                                        <input type="checkbox" class="checkbox-input" name="nature_of_work[]" value="{{ $investment->id }}">
                                                        {{ $investment->name }}
                                                    </label>
                                                @endforeach

                                            </div>
                                        </div>
                                        <div class="g-recaptcha" data-sitekey="{{ config('services.recaptcha.site_key') }}"></div>
                                        <div class="form-item">
                                            <button type="submit">Submit</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Claim Now ends -->
            
        </div>
        <!-- /main content -->

        <!-- footer -->
        @include('frontend.includes.footer')
        <!-- /footer -->
        
    </div>
    @include('frontend.includes.footer-link')
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
</body>
</html>

