
<!DOCTYPE html>
<html>
<head>
    <title>Blogs</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">    
    @include('frontend.includes.header-link')

</head>
<body>

    <!-- <div id="loader"></div> -->

    <div class="main-body" >

        <!-- header -->
        @include('frontend.includes.header')
        <!-- /header -->

        <!-- main content -->
        <div class="main-content">

            <!-- banner starts -->
            <div class="banner-sec" style="background-image: url(assets/images/about-banner-bg.png);">
                <div class="container">
                    <div class="banner-wrapper">
                        <h1>
                            Blogs
                        </h1>
                        <p>
                            
                        </p>
                        <div class="scroll-div d-flex align-items-center justify-content-center">
                            <p>
                                scroll down
                                <br><br>
                                <img src="assets/images/fi_6364586.png" alt="...">
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /banner ends -->

            <!-- blags starts -->
            <div class="blog-sec">
                <div class="container">
                    <div class="blog-wrspper">
                        <div class="row">
                            @foreach($blogs as $blog)
                                <div class="col-lg-4 col-md-6 col-12">
                                    <div class="blog-item">
                                        <div class="blog-item-img-heading">
                                            <img src="{{ asset($blog->image) }}" alt="{{ $blog->title }}">
                                            <div class="blog-item-heading">
                                                <div class="d-flex align-items-center mb-3">
                                                    <p class="mr-2">
                                                        <img src="{{ asset('assets/images/blog-user-icon.png') }}" alt="">
                                                        by Admin
                                                    </p>
                                                    <p>
                                                        <img src="{{ asset('assets/images/blog-folder-icon.png') }}" alt="">
                                                        Blog
                                                    </p>
                                                </div>
                                                <h6>{{ \Illuminate\Support\Str::limit($blog->title, 50) }}</h6>
                                                <p class="date-p">
                                                    {{ \Carbon\Carbon::parse($blog->created_at)->format('d') }} <br>
                                                    <span>{{ \Carbon\Carbon::parse($blog->created_at)->format('M') }}</span>
                                                </p>
                                            </div>
                                        </div>
                                        <p class="mb-4">
                                            {{ \Illuminate\Support\Str::limit(strip_tags($blog->body), 150) }}
                                        </p>
                                        <a href="{{ route('blogs.show', $blog->slug) }}">
                                            <img src="{{ asset('assets/images/arrow.png') }}" alt="...">
                                            <span>Read More</span>
                                        </a>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                    @if ($blogs->hasPages())
                        <div class="blog-pagination">
                            <div class="blog-pagination-list text-center d-flex justify-content-center align-items-center gap-2 flex-wrap">

                                {{-- Previous Page --}}
                                @if ($blogs->onFirstPage())
                                    <span><img src="{{ asset('assets/images/pagination-left.png') }}" alt="..."></span>
                                @else
                                    <a href="{{ $blogs->previousPageUrl() }}">
                                        <img src="{{ asset('assets/images/pagination-left.png') }}" alt="...">
                                    </a>
                                @endif

                                {{-- Page Numbers --}}
                                @foreach ($blogs->getUrlRange(1, $blogs->lastPage()) as $page => $url)
                                    @if ($page == $blogs->currentPage())
                                        <a >{{ $page }}</a>
                                    @else
                                        <a href="{{ $url }}" >{{ $page }}</a>
                                    @endif
                                @endforeach

                                {{-- Next Page --}}
                                @if ($blogs->hasMorePages())
                                    <a href="{{ $blogs->nextPageUrl() }}">
                                        <img src="{{ asset('assets/images/pagination-right.png') }}" alt="...">
                                    </a>
                                @else
                                    <span><img src="{{ asset('assets/images/pagination-right.png') }}" alt="..."></span>
                                @endif

                            </div>
                        </div>
                    @endif

                </div>
            </div>
            <!-- /blags ends -->
            
        </div>
        <!-- /main content -->

        <!-- footer -->
        @include('frontend.includes.footer')
        <!-- /footer -->
        
    </div>
    @include('frontend.includes.footer-link')

</body>
</html>

