<!DOCTYPE html>
<html>
<head>
    <title>{{ $blog->title ?? 'Blog Details' }}</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    @include('frontend.includes.header-link')
</head>
<body>

<div class="main-body">

    <!-- header -->
    @include('frontend.includes.header')
    <!-- /header -->

    <!-- main content -->
    <div class="main-content">

        <!-- banner starts -->
        <div class="banner-sec" style="background-image: url('{{ asset('assets/images/about-banner-bg.png') }}');">
            <div class="container">
                <div class="banner-wrapper">
                    <div class="blog-details-banner"></div>
                </div>
            </div>
        </div>
        <!-- /banner ends -->

        <!-- blog details starts -->
        <div class="blog-details-sec">
            <div class="container">
                <div class="blog-details-wrapper">
                    <img src="{{ asset($blog->image) }}" class="blog-details-banner" alt="{{ $blog->title }}">
                    <div class="blog-details-part">
                        <div class="row">
                            <div class="col-lg-8 col-md-12 col-12">
                                <div class="blog-details-content">
                                    <div class="blog-details-comments d-flex mb-4">
                                        <p>
                                            <img src="{{ asset('assets/images/user-1.png') }}" alt="...">
                                            by {{ $blog->author ?? 'Admin' }}
                                        </p>
                                        <!-- <p>
                                            <img src="{{ asset('assets/images/folder-1.png') }}" alt="...">
                                            {{ $blog->category->name ?? 'Uncategorized' }}
                                        </p> -->
                                        <p>
                                            <img src="{{ asset('assets/images/calendar_icon.png') }}" alt="">
                                            {{ $blog->created_at->format('d M Y') }}
                                        </p>
                                    </div>
                                    <h2>{{ $blog->title }}</h2>
                                    <h6>{{ $blog->short_description }}</h6>
                                    <p>{!! $blog->body !!}</p>

                                    @if($blog->sub_image)
                                        <img src="{{ asset('assets/admin/blog-images/' . $blog->sub_image) }}" class="sub-banner" alt="...">
                                    @endif

                                    @if($blog->sub_heading)
                                        <h5>{{ $blog->sub_heading }}</h5>
                                    @endif
                                    @if($blog->sub_content)
                                        <p>{!! $blog->sub_content !!}</p>
                                    @endif
                                </div>
                            </div>

                            <!-- Sidebar -->
                            <div class="col-lg-4 col-md-12 col-12">
                                <div class="blog-details-list">
                                    <div class="blog-details-list-box">
                                        <p>
                                            Welcome to your go-to destination for fresh perspectives. Dive deep into our rich content pool curated meticulously to enlighten, entertain, and engage readers across the globe.
                                        </p>
                                        <div class="blog-details-list-item">
                                            <a href="#"><img src="{{ asset('assets/images/blog-details-fb.png') }}" alt="..."></a>
                                            <a href="#"><img src="{{ asset('assets/images/blog-details-yt.png') }}" alt="..."></a>
                                            <a href="#"><img src="{{ asset('assets/images/blog-details-insta.png') }}" alt="..."></a>
                                            <a href="#"><img src="{{ asset('assets/images/blog-details-ld.png') }}" alt="..."></a>
                                        </div>
                                    </div>

                                    <!-- Featured Posts -->
                                    <div class="blog-details-fp mt-4">
                                        <h5>Featured Posts</h5>
                                        <div class="blog-details-fp-list">
                                            @foreach($featuredPosts as $post)
                                                <div class="blog-details-fp-list-item d-flex align-items-center">
                                                    <img src="{{ asset($post->image) }}" alt="{{ $post->title }}">
                                                    <div class="blog-details-fp-list-content">
                                                        <p>
                                                            <img src="{{ asset('assets/images/user-1.png') }}" alt="...">
                                                            by {{ $post->author ?? 'Admin' }}
                                                        </p>
                                                       
                                                            
                                                        
                                                        <a href="{{ route('blogs.show', $post->slug) }}">
                                                            <h6> {{ Str::limit($post->title, 50) }} </h6>
                                                        </a>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- /Sidebar -->
                        </div>

                        <!-- Related Blogs -->
                        <div class="blog-sec pb-0">
                            <div class="heading-sec d-flex align-items-end justify-content-between mb-0 pl-3">
                                <div class="heading-text">
                                    <h3>You Also Like</h3>
                                    <p class="mb-0">Discover more articles related to this topic.</p>
                                </div>
                            </div>

                            <div class="blog-wrspper">
                                <div class="row">
                                    @foreach($relatedPosts as $post)
                                        <div class="col-lg-4 col-md-4 col-12">
                                            <div class="blog-item">
                                                <div class="blog-item-img-heading">
                                                    <img src="{{ asset($post->image) }}" alt="{{ $post->title }}">
                                                    <div class="blog-item-heading">
                                                        <div class="d-flex align-items-center mb-3">
                                                            <p class="mr-2">
                                                                <img src="{{ asset('assets/images/blog-user-icon.png') }}" alt="">
                                                                by {{ $post->author ?? 'Admin' }}
                                                            </p>
                                                            <p>
                                                                <img src="{{ asset('assets/images/blog-folder-icon.png') }}" alt="">
                                                                {{ $post->category->name ?? 'Blog' }}
                                                            </p>
                                                        </div>
                                                        <h6>
                                                            <!-- {{ Str::limit($post->title, 50) }} -->
                                                        {{ \Illuminate\Support\Str::limit($post->title, 50) }}
                                                        </h6>
                                                        <p class="date-p">
                                                            {{ $post->created_at->format('d') }}<br>
                                                            <span>{{ $post->created_at->format('M') }}</span>
                                                        </p>
                                                    </div>
                                                </div>
                                                <p class="mb-4">
                                                    <!-- {{ Str::limit(strip_tags($post->body), 150) }} -->
                                                    {{ \Illuminate\Support\Str::limit(strip_tags($post->body), 150) }}
                                                </p>
                                                <a href="{{ route('blogs.show', $post->slug) }}">
                                                    <img src="{{ asset('assets/images/arrow.png') }}" alt="...">
                                                    <span>Read More</span>
                                                </a>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                        <!-- /Related Blogs -->

                    </div>
                </div>
            </div>
        </div>
        <!-- /blog details ends -->

    </div>
    <!-- /main content -->

    <!-- footer -->
    @include('frontend.includes.footer')
    <!-- /footer -->

</div>

@include('frontend.includes.footer-link')

</body>
</html>
