@extends('layouts.admin')

@section('content')
<div class="container mt-4">
    <div class="card shadow-sm">
        <div class="card-header d-flex justify-content-between align-items-center bg-primary text-white">
            <h4 class="mb-0">Who We Help List</h4>
            <a href="{{ route('admin.whowehelp.create') }}" class="btn btn-dark btn-sm">+ Add New</a>
        </div>
        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif

            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Title</th>
                        <th>Image</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($data as $item)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $item->title }}</td>
                            <td>
                                @if($item->image)
                                <img src="{{ asset($item->image) }}" width="100">

                                @else
                                    N/A
                                @endif
                            </td>
                            <td>
                            <a href="{{ route('admin.whowehelp.edit', $item->slug) }}" class="btn btn-sm btn-warning">
                                <i class="fas fa-edit"></i> 
                            </a>

                            <form action="{{ route('admin.whowehelp.destroy', $item->slug) }}" method="POST" class="d-inline" onsubmit="return confirm('Delete this entry?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger">
                                    <i class="fas fa-trash-alt"></i> 
                                </button>
                            </form>
                        </td>

                        </tr>
                    @empty
                        <tr><td colspan="4">No records found.</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
