@extends('layouts.admin')

@section('content')
<div class="container mt-4">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h4>{{ isset($whowehelp) ? 'Edit' : 'Add' }} Who We Help</h4>
        </div>
        <div class="card-body">
            <form action="{{ route('admin.whowehelp.storeOrUpdate', $whowehelp->id ?? '') }}" method="POST" enctype="multipart/form-data">
                @csrf

                <div class="form-group mb-3">
                    <label>Title</label>
                    <input type="text" name="title" class="form-control" value="{{ old('title', $whowehelp->title ?? '') }}" required>
                    @error('title') <div class="text-danger">{{ $message }}</div> @enderror
                </div>
                <div class="form-group mb-3">
                    <label>Subtitle</label>
                    <input type="text" name="subtitle" class="form-control" value="{{ old('subtitle', $whowehelp->subtitle ?? '') }}">
                    @error('subtitle') <div class="text-danger">{{ $message }}</div> @enderror
                </div>

                <div class="form-group mb-3">
                    <label>Short Description</label>
                    <textarea name="short_description" class="form-control" rows="3">{{ old('short_description', $whowehelp->short_description ?? '') }}</textarea>
                    @error('short_description') <div class="text-danger">{{ $message }}</div> @enderror
                </div>

                <div class="form-group mb-3">
                    <label>Body</label>
                    <textarea name="body" id="body" class="form-control" rows="5" required>{{ old('body', $whowehelp->body ?? '') }}</textarea>
                    @error('body') <div class="text-danger">{{ $message }}</div> @enderror
                </div>

                <div class="form-group mb-3">
                    <label>Image (optional)</label>
                    <input type="file" name="image" class="form-control" onchange="previewImage(event)">

                    @error('image') <div class="text-danger">{{ $message }}</div> @enderror

            
                    <img id="previewImage"
                    src="{{ isset($whowehelp) && $whowehelp->image ? asset($whowehelp->image) : '' }}"
                    class="img-thumbnail mt-2"
                    width="150"
                    style="{{ isset($whowehelp) && $whowehelp->image ? '' : 'display:none;' }}">

                </div>

                <button type="submit" class="btn btn-success w-100">{{ isset($whowehelp) ? 'Update' : 'Save' }}</button>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.ckeditor.com/4.21.0/full/ckeditor.js"></script>
<script>
    CKEDITOR.replace('body', {
        height: 300
    });
    function previewImage(event) {
        const reader = new FileReader();
        reader.onload = function(){
            const output = document.getElementById('previewImage');
            output.src = reader.result;
            output.style.display = 'block';
        };
        reader.readAsDataURL(event.target.files[0]);
    }
</script>


@endsection
