@extends('layouts.admin')

@section('content')
<div class="container mt-4">
    
    <div class="card shadow-sm">
        <div class="card-header d-flex justify-content-between align-items-center bg-primary text-white">
            <h4 class="mb-0">What We Do List</h4>
            <a href="{{ route('admin.what-we-do.create') }}" class="btn btn-dark btn-sm">+ Add New</a>
        </div>
        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif

            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Title</th>
                        <th>Image</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($data as $item)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $item->title }}</td>
                            <td>
                                @if($item->image)
                                    <img src="{{ asset($item->image) }}" width="100">
                                @else
                                    N/A
                                @endif
                            </td>
                            <td>
                                <button class="btn btn-sm {{ $item->status ? 'btn-success' : 'btn-secondary' }} toggle-status"
                                    data-id="{{ $item->id }}">
                                    {{ $item->status ? 'Active' : 'Inactive' }}
                                </button>
                            </td>
                            <td>
                                <a href="{{ route('admin.what-we-do.edit', $item->slug) }}" class="btn btn-sm btn-warning">
                                    <i class="fas fa-edit"></i>
                                </a>

                                <form action="{{ route('admin.what-we-do.destroy', $item->slug) }}" method="POST"
                                    class="d-inline" onsubmit="return confirm('Delete this entry?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger">
                                        <i class="fas fa-trash-alt"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5">No records found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

{{-- AJAX for status toggle --}}
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $('.toggle-status').click(function () {
        const button = $(this);
        const id = button.data('id');

        $.post("{{ url('admin/what-we-do/status') }}/" + id, {
            _token: "{{ csrf_token() }}"
        }, function (res) {
            if (res.status) {
                const isActive = button.text().trim() === 'Active';
                button.toggleClass('btn-success btn-secondary');
                button.text(isActive ? 'Inactive' : 'Active');
            }
        });
    });
</script>
@endsection
