@extends('layouts.admin')

@section('content')
<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-sm-12">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0">{{ $testimonial->id ? 'Edit' : 'Add' }} Testimonial</h4>
                </div>

                <div class="card-body">
                    <form method="POST" 
                          action="{{ $testimonial->id ? route('admin.testimonials.update', $testimonial->id) : route('admin.testimonials.store') }}" 
                          enctype="multipart/form-data">
                        @csrf
                        @if($testimonial->id)
                            @method('PUT')
                        @endif

                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <div class="form-group mb-3">
                            <label for="name">Name <span class="text-danger">*</span></label>
                            <input type="text" name="name" class="form-control" id="name" value="{{ old('name', $testimonial->name) }}" required>
                        </div>

                        <div class="form-group mb-3">
                            <label for="designation">Designation</label>
                            <input type="text" name="designation" class="form-control" id="designation" value="{{ old('designation', $testimonial->designation) }}">
                        </div>

                        <div class="form-group mb-3">
                            <label for="message">Message <span class="text-danger">*</span></label>
                            <textarea name="message" id="message" class="form-control" rows="5" required>{{ old('message', $testimonial->message) }}</textarea>
                        </div>

                        <div class="form-group mb-3">
                            <label for="image">Image (optional)</label>
                            <input type="file" name="image" class="form-control" onchange="imagePreview(event)">
                            <img 
                                id="previewImage" 
                                src="{{ $testimonial->image ? asset($testimonial->image) : '' }}" 
                                style="max-width: 150px; margin-top: 10px; {{ $testimonial->image ? '' : 'display:none;' }}"
                                class="img-thumbnail"
                            >
                        </div>

                        <button type="submit" class="btn btn-success w-100">
                            {{ $testimonial->id ? 'Update' : 'Add' }} Testimonial
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function imagePreview(event) {
        const file = event.target.files[0];
        const output = document.getElementById('previewImage');
        if (!file) return;

        const reader = new FileReader();
        reader.onload = function () {
            output.src = reader.result;
            output.style.display = 'block';
        };
        reader.readAsDataURL(file);
    }
</script>
@endsection
