@extends('layouts.admin')

@section('content')
<div class="container-fluid mt-4 px-4">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white d-flex justify-content-between">
            <h4 class="mb-0">Contact Submissions</h4>
            <a href="{{ route('admin.contact-us.create') }}" class="btn btn-dark btn-sm">+ Add Entry</a>
        </div>

        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif

            <div class="table-responsive">
                <table class="table table-bordered table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>City</th>
                            <th>Nature of Work</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($contacts as $contact)
                            <tr>
                                <td>{{ $contact->name }}</td>
                                <td>{{ $contact->email }}</td>
                                <td>{{ $contact->phone }}</td>
                                <td>{{ $contact->city }}</td>
                                <td>
                                    @foreach($contact->nature_of_work ?? [] as $id)
                                        <span class="badge bg-info text-dark">{{ \App\Models\NatureOfInvestment::find($id)->name ?? 'N/A' }}</span>
                                    @endforeach
                                </td>
                                <td>
                                    <a href="{{ route('admin.contact-us.edit', $contact->id) }}" class="btn btn-warning btn-sm">Edit</a>
                                    <form action="{{ route('admin.contact-us.destroy', $contact->id) }}" method="POST" style="display:inline;" onsubmit="return confirm('Delete this?')">
                                        @csrf @method('DELETE')
                                        <button class="btn btn-danger btn-sm">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr><td colspan="6" class="text-center text-muted">No records found.</td></tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="d-flex justify-content-end">
                {{ $contacts->links() }}
            </div>
        </div>
    </div>
</div>
@endsection
