@extends('layouts.admin')

@section('content')
<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-sm-12">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0">{{ isset($contact) ? 'Edit' : 'Add' }} Contact Entry</h4>
                </div>

                <div class="card-body">
                    <form action="{{ isset($contact) ? route('admin.contact-us.update', $contact->id) : route('admin.contact-us.store') }}" method="POST">
                        @csrf
                        @if(isset($contact)) @method('PUT') @endif

                        <div class="mb-3">
                            <label>Name</label>
                            <input type="text" name="name" class="form-control" value="{{ old('name', $contact->name ?? '') }}" required>
                        </div>
                        <div class="mb-3">
                            <label>Email</label>
                            <input type="email" name="email" class="form-control" value="{{ old('email', $contact->email ?? '') }}" required>
                        </div>
                        <div class="mb-3">
                            <label>Phone</label>
                            <input type="text" name="phone" class="form-control" value="{{ old('phone', $contact->phone ?? '') }}">
                        </div>
                        <div class="mb-3">
                            <label>City</label>
                            <input type="text" name="city" class="form-control" value="{{ old('city', $contact->city ?? '') }}">
                        </div>
                        <div class="mb-3">
                            <label>Nature of Work</label><br>
                            @php
                                $selectedWorkIds = [];
                                if (isset($contact) && !empty($contact->nature_of_work)) {
                                    $selectedWorkIds = explode(',', $contact->nature_of_work);
                                }
                            @endphp

                            @foreach($natureOfInvestments as $investment)
                                <div class="form-check form-check-inline">
                                    <input type="checkbox" name="nature_of_work[]" class="form-check-input"
                                        value="{{ $investment->id }}"
                                        {{ in_array($investment->id, $selectedWorkIds) ? 'checked' : '' }}>
                                    <label class="form-check-label">{{ $investment->name }}</label>
                                </div>
                            @endforeach

                        </div>

                        <button type="submit" class="btn btn-primary">{{ isset($contact) ? 'Update' : 'Submit' }}</button>
                        <a href="{{ route('admin.contact-us.index') }}" class="btn btn-secondary">Back</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
