@extends('layouts.admin')

@section('content')
<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-sm-12">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0">{{ isset($blog) ? 'Edit' : 'Create' }} Blog</h4>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{ isset($blog) ? route('admin.blogs.update', $blog) : route('admin.blogs.store') }}" enctype="multipart/form-data">
                        @csrf
                        @if ($errors->any())
                            <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                            </div>
                        @endif
                        @if(isset($blog)) @method('PUT') @endif

                        <div class="form-group mb-3">
                            <label for="title">Title</label>
                            <input type="text" name="title" class="form-control" id="title" value="{{ old('title', $blog->title ?? '') }}" required>
                        </div>

                        <div class="form-group mb-3">
                            <label for="body">Body</label>
                            <textarea name="body" id="body" class="form-control" rows="10">{{ old('body', $blog->body ?? '') }}</textarea>
                        </div>

                        <div class="form-group mb-3">
                            <label for="image">Image</label>
                            <input type="file" name="image" class="form-control" onchange="imagePreview(event)" required>
                            <img 
                                id="previewImage" 
                                src="{{ isset($blog) && $blog->image ? asset($blog->image) : '' }}" 
                                style="max-width: 150px; margin-top: 10px; {{ isset($blog) && $blog->image ? '' : 'display:none;' }}"
                                class="img-thumbnail"
                            >
                        </div>

                        <div class="form-group mb-3">
                            <label for="video">Video URL</label>
                            <input type="text" name="video" class="form-control" value="{{ old('video', $blog->video ?? '') }}">
                        </div>

                        <div class="form-group mb-3">
                            <label for="meta_title">Meta Title</label>
                            <input type="text" name="meta_title" class="form-control" value="{{ old('meta_title', $blog->meta_title ?? '') }}">
                        </div>

                        <div class="form-group mb-4">
                            <label for="meta_description">Meta Description</label>
                            <input type="text" name="meta_description" class="form-control" value="{{ old('meta_description', $blog->meta_description ?? '') }}">
                        </div>

                        <button class="btn btn-success w-100">{{ isset($blog) ? 'Update' : 'Create' }}</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- CKEditor 4 Full version -->
<script src="https://cdn.ckeditor.com/4.21.0/full/ckeditor.js"></script>
<script>
    CKEDITOR.replace('body', {
        height: 300
    });

    // function previewImage(event) {
    //     var reader = new FileReader();
    //     reader.onload = function(){
    //         const output = document.getElementById('previewImage');
    //         output.src = reader.result;
    //         output.style.display = 'block';
    //     };
    //     reader.readAsDataURL(event.target.files[0]);
    // }
</script>
<script>
    function imagePreview(event) {
        const file = event.target.files[0];
        const img = new Image();
        const objectUrl = URL.createObjectURL(file);

        img.onload = function () {
            if (img.width !== 1169 || img.height !== 414) {
                alert('Image must be exactly 1169x414 pixels.');
                event.target.value = ''; // reset file input
                document.getElementById('previewImage').style.display = 'none';
            } else {
                const output = document.getElementById('previewImage');
                output.src = objectUrl;
                output.style.display = 'block';
            }
            URL.revokeObjectURL(objectUrl);
        };

        img.src = objectUrl;
    }
</script>

@endsection
