@extends('layouts.admin')

@section('content')
<div class="container mt-4">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
            <h4 class="mb-0">About Us</h4>
            <a href="{{ route('admin.about.edit') }}" class="btn btn-warning btn-sm">Edit</a>
        </div>
        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif

            <h5>{{ old('title', $about->title ?? '') }}
            </h5>

            @if(isset($about) && $about->image)
                <img src="{{ asset($about->image) }}" alt="..." />
            @endif


            <div>
                @if(isset($about) && $about->body)
                    {!! $about->body !!}
                @else
                    <p>No about content available.</p>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
