@extends('layouts.admin')

@section('content')
<div class="container mt-4">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h4>Edit About Us</h4>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.about.update') }}" enctype="multipart/form-data">
                @csrf
                @method('PUT')

                <div class="form-group mb-3">
                    <label for="title">Title</label>
                    <input type="text" name="title" class="form-control" value="{{ old('title', $about->title ?? '') }}" required>
                    @error('title')
                        <div class="text-danger">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group mb-3">
                    <label for="body">Body</label>
                    <textarea name="body" id="body" rows="10" class="form-control" required>{{ old('body', $about->body ?? '') }}</textarea>
                    @error('body')
                        <div class="text-danger">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group mb-3">
                    <label for="image">Image (1169x414)</label>
                    <input type="file" name="image" class="form-control" onchange="previewImage(event)">
                    @error('image')
                        <div class="text-danger">{{ $message }}</div>
                    @enderror

                    @if(isset($about) && $about->image)
                        <img id="previewImage" src="{{ asset($about->image) }}" style="max-width: 150px; margin-top: 10px;" class="img-thumbnail">
                    @else
                        <img id="previewImage" style="display:none; max-width: 150px; margin-top: 10px;" class="img-thumbnail">
                    @endif
                </div>

                <button type="submit" class="btn btn-success w-100">Update</button>
            </form>
        </div>
    </div>
</div>

<script>
    function previewImage(event) {
        const reader = new FileReader();
        reader.onload = function() {
            const output = document.getElementById('previewImage');
            output.src = reader.result;
            output.style.display = 'block';
        };
        reader.readAsDataURL(event.target.files[0]);
    }
</script>
@endsection
