<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;

class WhatWeDo extends Model
{
    use Sluggable;

    protected $fillable = [
        'title',
        'sub_title',
        'short_description',
        'description',
        'slug',
        'image',
        'status',
    ];

    /**
     * Return the sluggable configuration array for this model.
     */
    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'title'
            ]
        ];
    }
}
