<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\WhoWeHelp;
use App\Models\Blog;
use App\Models\Testimonial;

class FrontendHomeController extends Controller
{
    public function index()
    {
        $whoWeHelpItems = WhoWeHelp::get();
        $blogs = Blog::latest()->limit(3)->get();
        $testimonials = Testimonial::latest()->get();
// dd($blogs);
        return view('frontend.index', compact('whoWeHelpItems', 'blogs', 'testimonials'));
    }
    public function show($slug)
    {
        $item = WhoWeHelp::where('slug', $slug)->firstOrFail();
        $alldata = WhoWeHelp::where('slug', '!=', $slug)->get();
        return view('frontend.who-we-help-details', compact('item','alldata'));
    }

    public function WhowehelpList(){
        $WhoWeDoList = WhoWeHelp::get();
        // dd(json_decode($WhatWeDoList));
        return view('frontend.whowehelp-list', compact('WhoWeDoList'));
    }
}
