<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Blog;

class FrontendBlogController extends Controller
{
    public function index()
    {
        $blogs = Blog::latest()->paginate(6);
        return view('frontend.blog', compact('blogs'));
    }

    public function show($slug)
    {
        $blog = Blog::where('slug', $slug)->firstOrFail();
        $featuredPosts = Blog::where('id', '!=', $blog->id)->latest()->take(5)->get();
        $relatedPosts = Blog::where('slug', '!=', $slug)->latest()->take(3)->get();

        return view('frontend.blog-details', compact('blog', 'featuredPosts', 'relatedPosts'));
    }

}
