<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use App\Models\WhoWeHelp;
use Illuminate\Http\Request;

class WhoWeHelpController extends Controller
{
    public function index()
    {
        $data = WhoWeHelp::all();
        return view('admin.whowehelp.index', compact('data'));
    }

    public function create()
    {
        return view('admin.whowehelp.addedit');
    }

    public function storeOrUpdate(Request $request, $id = null)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'subtitle' => 'nullable|string|max:255',
            'short_description' => 'nullable|string',
            'body' => 'required|string',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,webp',
        ]);
        

        $whowehelp = $id ? WhoWeHelp::findOrFail($id) : new WhoWeHelp();
        $whowehelp->title = $request->title;
        $whowehelp->subtitle = $request->subtitle;
        $whowehelp->short_description = $request->short_description;
        $whowehelp->body = $request->body;

        // Handle image upload
        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $filename = time() . '_' . $file->getClientOriginalName();
            $path = 'assets/admin/who-we-help-images/';
            $file->move(public_path($path), $filename);
            $whowehelp->image = $path . $filename;
        }

        $whowehelp->save();

        return redirect()->route('admin.whowehelp.index')->with('success', 'Saved successfully.');
    }



    public function edit(WhoWeHelp $whowehelp)
    {
        return view('admin.whowehelp.addedit', compact('whowehelp'));
    }

    public function destroy(WhoWeHelp $whowehelp)
    {
        $whowehelp->delete();
        return back()->with('success', 'Deleted successfully.');
    }
}
