<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\WhatWeDo;

class WhatWeDoController extends Controller
{
    public function createFrom()
    {
        return view('admin.what_we_do.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'sub_title' => 'nullable|string|max:255',
            'short_description' => 'nullable|string',
            'description' => 'nullable|string',
            'image' => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
            'status' => 'required|boolean',
        ]);

        $data = $request->only([
            'title', 'sub_title', 'short_description', 'description', 'status'
        ]);

        // Handle image upload
        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $filename = time() . '_' . $image->getClientOriginalName();
            $image->move(public_path('assets/admin/what-we-do'), $filename);
            $data['image'] = 'assets/admin/what-we-do/' . $filename;
        }

        WhatWeDo::create($data);

        return redirect()->route('admin.what-we-do.create')->with('success', 'What We Do entry added successfully!');
    }
    public function index()
    {
        $data = WhatWeDo::latest()->get();
        return view('admin.what_we_do.index', compact('data'));
    }
    // Edit form
    public function edit($slug)
    {
        $item = WhatWeDo::where('slug', $slug)->firstOrFail();
        return view('admin.what_we_do.edit', compact('item'));
    }

    // Update
    public function update(Request $request, $id)
    {
        $item = WhatWeDo::findOrFail($id);

        $request->validate([
            'title' => 'required|string|max:255',
            'sub_title' => 'nullable|string|max:255',
            'short_description' => 'nullable|string',
            'description' => 'nullable|string',
            'image' => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
            'status' => 'required|boolean',
        ]);

        $data = $request->only(['title', 'sub_title', 'short_description', 'description', 'status']);

        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $filename = time() . '_' . $image->getClientOriginalName();
            $image->move(public_path('assets/admin/what-we-do'), $filename);
            $data['image'] = 'assets/admin/what-we-do/' . $filename;
        }

        $item->update($data);

        return redirect()->route('admin.what-we-do.index')->with('success', 'Updated successfully.');
    }

    // Delete
    public function destroy($slug)
    {
        $item = WhatWeDo::where('slug', $slug)->firstOrFail();
        if ($item->image && file_exists(public_path($item->image))) {
            unlink(public_path($item->image));
        }
        $item->delete();

        return redirect()->route('admin.what-we-do.index')->with('success', 'Deleted successfully.');
    }

    // Toggle status
    public function toggleStatus($id)
    {
        $item = WhatWeDo::findOrFail($id);
        $item->status = !$item->status;
        $item->save();

        return response()->json(['status' => true, 'message' => 'Status updated.']);
    }
}
